<?php

namespace App\Http\Controllers\Hostel;

use App\Models\Hostel\Hostel;
use App\Http\Controllers\Controller;
use App\Models\Hostel\HostelRoom;
use App\Models\Hostel\StudentHostel;
use App\Models\Accounting\FeeType;
use App\Models\Accounting\StudentFee;
use Illuminate\Http\Request;


class MultipleAssignHostelRoomController extends Controller
{
    public function index(){
        $hostel_id = '';
        $floor_id = '';
        $room_id = '';
        $hostels = Hostel::pluck('name', 'id');
        return view('pages.hostels.multiple-student-assign.index', compact('hostels','hostel_id','floor_id','room_id'));
    }

    public function assignHostelRoom(Request $request){
        $student_ids = $request->input('student_id');
        $hostel_id = $request->input('hostel_id');
        $hostel_room_id = $request->input('room_id');
        $total_student = count($student_ids);
        if (empty($hostel_room_id)) {
            return redirect()->back()->with(['success' => false, 'message' => 'Please select a room!']);
        }

        $hostel_room = HostelRoom::with('roomType')->where('id', $hostel_room_id)->first();
        $total_bed = $hostel_room->no_of_bed;

        $assigned_bed = StudentHostel::where('hostel_room_id', $hostel_room_id)->count() ?? 0;
        $available_bed = $total_bed - $assigned_bed;

        if($total_student > $total_bed){
            return redirect()->back()->with(['danger' => 'Student over. Only '.$total_bed.' bed are available']);
        }

        $message = [];
        $error = [];

        foreach($student_ids as $student_id){

            $check_exist = StudentHostel::where('student_id', $student_id)
            ->exists();

            if($check_exist){
                $available_bed += 1;
            }
            $hostelFeeTypes = FeeType::where('code', 'HOSTEL')->get();

            if ($available_bed > 0 && !$check_exist) {
                // Store the data in your database
                StudentHostel::create([
                    'student_id' => $student_id,
                    'hostel_id' => $hostel_room->hostel_id,
                    'hostel_floor_id' => $hostel_room->hostel_floor_id,
                    'hostel_room_id' => $hostel_room_id,
                    'room_type_id' => $hostel_room->roomType->id,
                    'cost' => $hostel_room->roomType->cost_per_bed,
                ]);

                foreach ($hostelFeeTypes as $hostelFeeType) {
                    StudentFee::create([
                        'student_id' => $student_id,
                        'fee_type_id' => $hostelFeeType->id,
                        'month' => $hostelFeeType->month,
                        'amount' => $hostel_room->roomType->cost_per_bed,
                    ]);
                }

                $message[] = 'Student hostel room assigned successfully for student ID ' . $student_id . '!';



            } elseif ($available_bed > 0 && $check_exist) {
                StudentHostel::where('student_id', $student_id)->update([
                    'hostel_id' => $hostel_room->hostel_id,
                    'hostel_floor_id' => $hostel_room->hostel_floor_id,
                    'hostel_room_id' => $hostel_room_id,
                    'room_type_id' => $hostel_room->roomType->id,
                    'cost' => $hostel_room->roomType->cost_per_bed,
                ]);

                foreach ($hostelFeeTypes as $hostelFeeType) {
                    StudentFee::where('student_id', $student_id)
                        ->where('fee_type_id', $hostelFeeType->id)
                        ->update([
                            'amount' => $hostel_room->roomType->cost_per_bed,
                        ]);
                }

                $message[] = 'Student hostel room updated successfully for student ID ' . $student_id . '!';


            } elseif ($available_bed <= 0) {
                $message[] = 'No bed available for student ID ' . $student_id . ' Try different room!';

            } else {
                $error[] = 'Something went wrong for student ID ' . $student_id . ' Try Again!';
                
            }

        }

         // Return messages to the view
        return redirect()->back()->with([
            'message' => implode('<br>', $message),
            'error' => implode('<br>', $error)
        ]);
    }


}
