<?php

namespace App\Http\Controllers\Hostel;

use App\Http\Controllers\Controller;
use App\Models\Hostel\RoomType;
use Illuminate\Http\Request;

class RoomTypeController extends Controller
{
    public function index()
    {
        $roomTypes = RoomType::get();
        return view('pages.hostels.room_type.index', compact('roomTypes'));
    }

    public function create()
    {
        return view('pages.hostels.room_type.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'cost_per_bed' => 'required',
        ]);

        RoomType::create([
            'name' => $request->name,
            'cost_per_bed' => $request->cost_per_bed,
        ]);

        return redirect()->route('room-type.index')->with('success', 'Room type created successfully!');
    }

    public function edit(RoomType $roomType)
    {
        return view('pages.hostels.room_type.edit', compact('roomType'));
    }

    public function update(Request $request, RoomType $roomType)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'cost_per_bed' => 'required',
        ]);

        $roomType->update([
            'name' => $request->name,
            'cost_per_bed' => $request->cost_per_bed,
        ]);

        return redirect()->route('room-type.index')->with('success', 'Room type updated successfully!');
    }

    public function destroy(RoomType $roomType)
    {
        $roomType->delete();
        return redirect()->route('room-type.index')->with('success', 'Room type deleted successfully!');
    }
}
