<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrPayroll\Designation;

class DesignationController extends Controller
{
    public function index()
    {
        $designations = Designation::all();
        return view('pages.hr-payroll.designation.index', compact('designations'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250',
        ]);
        $item = new Designation();
        $item->name = $request->name;
        $item->save();
        return redirect()->route('designation.index')->with('success', 'Added successfully.');
    }

    public function edit($id)
    {
        $item = Designation::findOrFail($id);
        $designations = Designation::all();
        return view('pages.hr-payroll.designation.index', compact('designations', 'item'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250',
        ]);
        $item = Designation::findOrFail($request->id);
        $item->name = $request->name;
        $item->save();
        return redirect()->route('designation.index')->with('success', 'Updated successfully.');
    }

    public function destroy($id)
    {
        $item = Designation::findOrFail($id);
        
        $totalCount =
            $item->employee_count +
            $item->employee_attendance_count +
            $item->employee_education_count +
            $item->employee_salary_count +
            $item->employee_type_count +
            $item->hr_department_count +
            $item->leave_count +
            $item->leave_type_count +
            $item->monthly_salary_count +
            $item->occupation_count +
            $item->salary_grade_count +
            $item->salary_grade_rule_count +
            $item->salary_head_count +
            $item->teacher_count;
        // dd($totalCount);
        $item->delete();
        return redirect()->route('designation.index')->with('success', 'Updated successfully.');
    }
}
