<?php

namespace App\Http\Controllers\HrPayroll;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\Controller;
use App\Imports\EmployeeAttendanceImport;

class EmployeeAttendanceController extends Controller
{
    //EmployeeAttendance

    public function index(){
        return view('pages.hr-payroll.attendance.index');
    }

    public function attendanceFileUpload(Request $request){
        $request->validate([
            'attendance_file' => 'required|file|mimes:xlsx,xls',
        ]);

        // dd($request->file('attendance_file'));

        Excel::import(new EmployeeAttendanceImport(), request()->file('attendance_file'));

        return back()->with('success', 'Attendance file uploaded successfully!');
    }


}
