<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrPayroll\Employee;
use App\Services\HrPayroll\EmployeeService;

class EmployeeController extends Controller
{

    protected EmployeeService $employeeServicce;

    public function __construct(EmployeeService $employeeServicce)
    {
        $this->employeeServicce = $employeeServicce;
    }

    public function index(Request $request)
    {
        $data = $this->employeeServicce->getFormdData();
        $data['employees'] = $this->employeeServicce->getEmployee($request->query());
        $data['employee_name'] = getEmployeeNameWithCode($request->employee_code, $data['employees']);
        return view('pages.hr-payroll.employee.index', $data);
    }

    public function create()
    {
        $data = $this->employeeServicce->getRelatedData();
        return view('pages.hr-payroll.employee.create')->with($data);
    }

    public function store(Request $request)
    {
        $this->employeeServicce->store($request);
        return redirect()->route('employees.index')->with('success', 'Employee  created successfully.');
    }

    public function show($id)
    {
        $data = $this->employeeServicce->getRelatedData();
        $data['employee'] = $this->employeeServicce->getSingleEmployeeData($id);
        return view('pages.hr-payroll.employee.show',$data);
    }

    public function edit($id)
    {
        $data = $this->employeeServicce->getRelatedData();
        $data['employee'] = $this->employeeServicce->getSingleEmployeeData($id);
        return view('pages.hr-payroll.employee.edit')->with($data);
    }

    public function update(Request $request, Employee $employee)
    {
        $this->employeeServicce->update($request, $employee);
        return redirect()->route('employees.index')->with('success', 'Employee updated successfully.');
    }

    public function destroy($id)
    {
        $this->employeeServicce->delete($id);
        return redirect()->route('employees.index')->with('danger', "Employee delete successfully.");
    }

    //===============Auto Complete Search===================//
    public function searchEmployee(Request $request)
    {
        $students = $this->employeeServicce->searchEmployee($request->get('query'));
        return response()->json($students);
    }
}
