<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\HrPayroll\EmployeeSalaryService;

class EmployeeSalaryController extends Controller
{

    protected EmployeeSalaryService $employeeSalaryService;

    public function __construct(EmployeeSalaryService $employeeSalaryService)
    {
        $this->employeeSalaryService = $employeeSalaryService;
    }

    public function index(Request $request)
    {
        $employee_code = $request->employee_code ?? '';
        $data = $this->employeeSalaryService->getRelatedData();
        $data['employee_salaries'] = $this->employeeSalaryService->getEmployeeSalary($request);
        $data['employee_name'] = getEmployeeNameWithCode($employee_code, $data['employee_salaries']);
        return view('pages.hr-payroll.employee-salary.index', $data);
    }

    public function create(Request $request)
    {
        $employee_code = $request->employee_code ?? '';
        $data = $this->employeeSalaryService->getRelatedData();
        $data['employee'] = $this->employeeSalaryService->getEmployeeByCode($employee_code);
        $data['employee_name'] = getEmployeeNameWithCode($employee_code, $data['employee']);
        return view('pages.hr-payroll.employee-salary.create', $data);
    }

    public function store(Request $request)
    {
        $this->employeeSalaryService->storeEmployeeSalary($request);
        return redirect()->route('employee-salary.index')->with('success', 'Employee Salary created successfully.');
    }

    public function salarySheet(Request $request)
    {
        $data = $this->employeeSalaryService->getRelatedData();
        $data['newSalaries'] = $this->employeeSalaryService->salarySheet($request);
        $data['employee_name'] = getEmployeeNameWithCode($request->employee_code, $data['newSalaries']);
        return view('pages.hr-payroll.monthly-salary.index', $data);
    }


    public function monthlySalaryCreate(Request $request)
    {

        $data = $this->employeeSalaryService->getRelatedData();
        $data['employeeSalaries'] = $this->employeeSalaryService->getEmployeeMonthlySalary($request->query());
        $data['employee_name'] = getEmployeeNameWithCode($request->employee_code, $data['employeeSalaries']);

        return view('pages.hr-payroll.monthly-salary.create', $data);
    }

    public function monthlySalaryStore(Request $request)
    {
        $data = $this->employeeSalaryService->storeMonthlySalary($request);

        return redirect()->route('monthly-salary.sheet',[
            'employee_code' => $data['employee_code'] ?? "",
            'academicYear' => $data['academicYear'],
            'month' => $data['month'],
        ])->with($data);
    }

    public function monthlySalarySheet(Request $request)
    {
        $data = $this->employeeSalaryService->monthlySalarySheet($request);
        return view('pages.hr-payroll.monthly-salary.sheet', $data);
    }
}
