<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrPayroll\EmployeeType;
class EmployeeTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $types = EmployeeType::orderBy('id','desc')->get();
        return view('pages.hr-payroll.employee_type.index', compact('types'));

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.hr-payroll.employee_type.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $type = new EmployeeType();
        $type->emp_type = $request->emp_type;
        $type->status = $request->status;
        $type->save();
        return redirect()->route('employee_type.index')->with('success', 'Employee Type created successfully.');
    }


    public function show(EmployeeType $type)

    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */

    public function edit(EmployeeType $type)
    {
        return view('pages.hr-payroll.employee_type.edit', compact('type'));
    }

    /**
     * Update the specified resource in storage.
     */


    public function update(Request $request)
    {
        $type = EmployeeType::findOrFail($request->id);
        $type->emp_type = $request->emp_type;
        $type->status = $request->status;
        $type->save();
        return redirect()->route('employee_type.index')->with('success', 'Employee Type updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */

    public function destroy(EmployeeType $type)
    {
        $type->delete();
        return redirect()->route('employee_type.index')->with('success', 'Employee Type deleted successfully.');
    }
}
