<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use App\Models\HrPayroll\HrDepartment;
use Illuminate\Http\Request;

class HrDepartmentController extends Controller
{
    public function index()
    {
        $departments = HrDepartment::all();
        return view('pages.hr-payroll.department.index',compact('departments'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250',
        ]);
        $item = new HrDepartment();
        $item->name = $request->name;
        $item->save();
        return redirect()->route('hr-department.index')->with('success', 'Added successfully.');
    }

    public function update(Request $request){
        $request->validate([
            'name' => 'required|string|max:250',
        ]);
        $item = HrDepartment::findOrFail($request->id);
        $item->name = $request->name;
        $item->save();
        return redirect()->route('hr-department.index')->with('success', 'Updated successfully.');
    }

    public function destroy($id)
    {
        $item = HrDepartment::findOrFail($id);
        $item->delete();
        return redirect()->route('hr-department.index')->with('success', 'Updated successfully.');
    }
}
