<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use App\Models\HrPayroll\Leave;
use App\Models\HrPayroll\LeaveType;
use App\Services\FileUploadService;
use Illuminate\Http\Request;

class LeaveController extends Controller
{
    protected $fileUploadService;

    public function __construct(FileUploadService $fileUploadService)
    {
        $this->fileUploadService = $fileUploadService;
    }

    public function index()
    {
        $leave_list = Leave::with(['user', 'LeaveType'])->where('user_id', '=', auth()->user()->id)->orderBy('id', 'DESC')->get();
        $leaveTypes  = LeaveType::get();
        return view('pages.hr-payroll.leaves.index', compact('leave_list','leaveTypes'));
    }

    public function filterLeaveList(Request $request)
    {
        $from_date = $request->query('from_date', '');
        $to_date = $request->query('to_date', '');
        $leave_type = $request->query('leave_type', '');
        $status = $request->query('status', '');

        $leaveQuery = Leave::with('student', 'LeaveType');

        if (!empty($from_date)) {
            $leaveQuery->whereDate('leave_start_date', '>=', $from_date);
        }

        if (!empty($to_date)) {
            $leaveQuery->whereDate('leave_end_date', '<=', $to_date);
        }

        if (!empty($leave_type)) {
            $leaveQuery->where('leave_type_id', $leave_type);
        }

        if (!empty($status)) {
            $leaveQuery->where('status', $status);
        }

        $leave_list = $leaveQuery->orderBy('id','DESC')->get();

        $response['status'] = true;
        $response['message'] = "Leave get successfull.";
        $response['data'] = ['leave_list' => $leave_list];
        return response()->json($response, 200);
    }

    public function create()
    {
        $leaveTypes  = LeaveType::get();
        return view('pages.hr-payroll.leaves.create', compact('leaveTypes'));
    }

    public function store(Request $request)
    {

        $request->validate([
            'leave_type' => 'required|string',
            'from_date' => 'required',
            'to_date' => 'required',
        ]);


        $file_path = "";
        $destination = 'leave_reference_file';

        $from_date = store_date_format($request->from_date);
        $to_date = store_date_format($request->to_date);
        $requested_days = $request->requested_days;
        $LeaveData = [
            'user_id' => auth()->user()->id,
            'leave_type_id' => $request->leave_type,
            'branch_id' => auth()->user()->branch_id,
            'from_date' => $from_date,
            'to_date' => $to_date,
            'requested_days' => $requested_days,
            'leave_reason' => $request->leave_reason ?? '',
            'user_type' => auth()->user()->user_type,
            'created_by' => auth()->user()->id,
        ];

        if ($request->hasFile('file_path')){
            $LeaveData['reference_file'] = $this->fileUploadService->upload($request->file('file_path'), $destination);
        }

        Leave::create($LeaveData);

        return redirect()->route('leaves.index')->with('success', 'Leave created successfully!');

    }

    public function edit(Leave $leave)
    {
        $leaveTypes  = LeaveType::get();
        return view('pages.hr-payroll.leaves.edit', compact('leaveTypes', 'leave'));
    }

    public function details(Leave $leave)
    {
        $leaveTypes  = LeaveType::get();
        return view('pages.hr-payroll.leaves.details', compact('leaveTypes', 'leave'));
    }


    public function update(Request $request)
    {
        $leave = Leave::find($request->id);
        $request->validate([
            'leave_type' => 'required|string',
            'from_date' => 'required',
            'to_date' => 'required',
            'id' => 'required',
        ]);

        $file_path = "";
        $destination = 'leave_reference_file';

        $from_date = store_date_format($request->from_date);
        $to_date = store_date_format($request->to_date);
        $requested_days = $request->requested_days;
        $LeaveData = [
            'user_id' => auth()->user()->id,
            'leave_type_id' => $request->leave_type,
            'branch_id' => auth()->user()->branch_id,
            'from_date' => $from_date,
            'to_date' => $to_date,
            'requested_days' => $requested_days,
            'leave_reason' => $request->leave_reason ?? '',
            'user_type' => auth()->user()->user_type,
            'created_by' => auth()->user()->id,
        ];

        if ($request->hasFile('file_path')){
            $LeaveData['reference_file'] = $this->fileUploadService->upload($request->file('file_path'), $destination, $leave->reference_file);
        }
        Leave::where('id',$request->id)->update($LeaveData);
        return redirect()->route('leaves.index')->with('success', 'Leave updated successfully!');
    }

    public function destroy(Leave $leave)
    {
        $leave->delete();
        return redirect()->route('leaves.index')->with('success', 'Leave deleted successfully!');
    }

    public function leaveRequest()
    {
        $leave_list = Leave::with(['user', 'LeaveType'])->orderBy('id', 'DESC')->get();
        return view('pages.hr-payroll.leaave-request.index', compact('leave_list'));
    }

    public function leaveRequestCreate()
    {
        $leaveTypes  = LeaveType::get();
        return view('pages.hr-payroll.leaave-request.create', compact('leaveTypes'));
    }

    public function leaveRequestStore(Request $request)
    {
        
        $request->validate([
            'leave_type' => 'required|string',
            'from_date' => 'required',
            'to_date' => 'required',
        ]);


        $file_path = "";
        $destination = 'leave_reference_file';

        $from_date = $request->from_date;
        $to_date = $request->to_date;
        $requested_days = $request->requested_days;
        $LeaveData = [
            'user_id' => auth()->user()->id,
            'leave_type_id' => $request->leave_type,
            'branch_id' => auth()->user()->branch_id,
            'from_date' => $from_date,
            'to_date' => $to_date,
            'requested_days' => $requested_days,
            'leave_reason' => $request->leave_reason ?? '',
            'user_type' => auth()->user()->user_type,
            'created_by' => auth()->user()->id,
        ];

        if ($request->hasFile('file_path')){
            $LeaveData['reference_file'] = $file_path;
        }

        Leave::create($LeaveData);

        return redirect()->route('leaves-request.index')->with('success', 'Leave created successfully!');

    }

    public function leaveRequestEdit(Leave $leave)
    {
        $leaveTypes  = LeaveType::get();
        return view('pages.hr-payroll.leaave-request.edit', compact('leaveTypes', 'leave'));
    }

    public function leaveRequestUpdate(Request $request, Leave $leave)
    {

        $LeaveData = [
            'reject_reason' => $request->reject_reason,
            'status' => $request->status,
            'approved_days' => $request->approved_days,
            'updated_by' => auth()->user()->id,
        ];

        $leave->update($LeaveData);

        return redirect()->route('leaves-request.index')->with('success', 'Leave updated successfully!');

    }

}
