<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use App\Models\HrPayroll\LeaveType;
use Illuminate\Http\Request;

class LeaveTypeController extends Controller
{
    public function index()
    {
        $leave_types = LeaveType::all();
        return view('pages.hr-payroll.leave-type.index', compact('leave_types'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'short_name' => 'required|string',
            'allocated_days' => 'required|string',
        ]);

        $leave_type = LeaveType::create($request->all());
        return redirect()->route('leave-type.index')->with('success', 'Leave type created successfully!');
    }

    public function update(Request $request, LeaveType $leaveType)
    {
        $request->validate([
            'name' => 'required|string',
            'short_name' => 'required|string',
            'allocated_days' => 'required|string',
        ]);

        $leaveType->update($request->all());
        return redirect()->route('leave-type.index')->with('success', 'Leave type updated successfully!');
    }


    public function destroy(LeaveType $leaveType)
    {
        $leaveType->delete();
        return redirect()->route('leave-type.index')->with('success', 'Leave type deleted successfully!');
    }
}
