<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use App\Models\HrPayroll\Occupation;
use Illuminate\Http\Request;

class OccupationController extends Controller
{
    public function index()
    {
        $occupations = Occupation::all();
        return view('pages.hr-payroll.occupation.index', compact('occupations'));
    }

    public function create()
    {
        return view('pages.hr-payroll.occupation.create');
    }


    public function store(Request $request)
    {
        $request->validate([
            // Define validation rules for occupation creation
        ]);

        Occupation::create($request->all());

        return redirect()->route('occupation.index')
            ->with('success', 'Occupation created successfully.');
    }


    public function show(Occupation $occupation)
    {
        return view('pages.hr-payroll.occupation.show', compact('occupation'));
    }


    public function edit(Occupation $occupation)
    {
        return view('pages.hr-payroll.occupation.edit', compact('occupation'));
    }


    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250',
        ]);

        $occupation = Occupation::findOrFail($request->id);
        $occupation->name = $request->name;
        $occupation->save();

        return redirect()->route('occupation.index')
            ->with('success', 'Occupation updated successfully.');
    }


    public function destroy($id)
    {
        $occupation = Occupation::findOrFail($id);
        $occupation->delete();

        return redirect()->route('occupation.index')
            ->with('success', 'Occupation deleted successfully.');
    }
}
