<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use App\Models\HrPayroll\SalaryGrade;
use App\Models\HrPayroll\SalaryHead;
use App\Services\Accounting\SalarySettingService;
use Illuminate\Http\Request;

class SalarySettingController extends Controller
{

    private SalarySettingService $salarySettingService;

    public function __construct(SalarySettingService $salarySettingService)
    {
        $this->salarySettingService = $salarySettingService;
    }

    public function index()
    {
        $data = $this->salarySettingService->getRelatedData();
        return view('pages.hr-payroll.salary-setting.index', $data);
    }

    //===============Head CRUD===============//

    public function viewHead()
    {
        $data = $this->salarySettingService->getRelatedData();
        return view('pages.hr-payroll.salary-setting.salary-head',$data);
    }

    public function storeHead(Request $request)
    {
        $this->salarySettingService->storeHead($request);
        return redirect()->route('salary-setting.index')->with('success', 'Salary head created successfully.');
    }

    public function updateHead(Request $request, SalaryHead $salaryHead)
    {
        $this->salarySettingService->updateHead($request, $salaryHead);
        return redirect()->route('salary-setting.index')->with('success', 'Salary head updated successfully.');
    }

    public function destroyHead(SalaryHead $salaryHead)
    {
        $salaryHead->delete();
        return redirect()->route('salary-setting.index')->with('success', 'Salary head deleted successfully.');
    }

    //===============Grade CRUD===============//

    public function viewGrade()
    {
        $data = $this->salarySettingService->getRelatedData();
        return view('pages.hr-payroll.salary-setting.salary-grade', $data);
    }

    public function storeGrade(Request $request)
    {
        $this->salarySettingService->storeGrade($request);
        return redirect()->route('salary-setting.index')->with('success', 'Salary Grade created successfully.');
    }

    public function updateGrade(Request $request, $id)
    {
        $this->salarySettingService->updateGrade($request, $id);
        return redirect()->route('salary-setting.index')->with('success', 'Salary Grade updated successfully.');
    }

    public function editGrade($id)
    {
        $salaryGrade = SalaryGrade::with('salaryGradeRules.salaryHead')->find($id);
        return response()->json($salaryGrade);
    }

    public function destroyGrade($id)
    {
        $this->salarySettingService->deleteGrade($id);
        return redirect()->route('salary-setting.index')->with('success', 'Salary Grade deleted successfully.');
    }

}
