<?php

namespace App\Http\Controllers\HrPayroll;

use App\Http\Controllers\Controller;
use App\Models\HrPayroll\Employee;
use App\Services\TeacherInfoService;
use Illuminate\Http\Request;

class TeacherController extends Controller
{

    protected $teacherInfoService;

    public function __construct(TeacherInfoService $teacherInfoService)
    {
        $this->teacherInfoService = $teacherInfoService;
    }

    public function index()
    {
        $teachers = $this->teacherInfoService->getTeacherData();
        return view("pages.teacher.teacher-info.index", compact('teachers'));
    }

    public function create()
    {
        $data = $this->teacherInfoService->getRelatedData();
        return view("pages.teacher.teacher-info.create", $data);
    }

    public function store(Request $request)
    {
        $this->teacherInfoService->store($request);
        return redirect()->route('teacher.index')->with('success', 'Teacher  created successfully.');
    }

    public function show($id)
    {
        $data = $this->teacherInfoService->getRelatedData();
        $data['employee'] = $this->teacherInfoService->getSingleTeacherData($id);
        return view("pages.teacher.teacher-info.show", $data);
    }

    public function edit($id)
    {
        $data = $this->teacherInfoService->getRelatedData();
        $data['employee'] = $this->teacherInfoService->getSingleTeacherData($id);
        return view("pages.teacher.teacher-info.edit", $data);
    }

    public function update(Request $request, Employee $employee)
    {
        $this->teacherInfoService->update($request, $employee);
        return redirect()->route('teacher.index')->with('success', 'Teacher  updated successfully.');
    }

    public function destroy($id)
    {
        $this->teacherInfoService->delete($id);
        return redirect()->route('teacher.index')->with('danger', "Teacher deleted successfully!");
    }
}
