<?php

namespace App\Http\Controllers\Hsc;

use Illuminate\Http\Request;
use App\Models\Academic\Group;
use App\Models\Academic\Subject;
use App\Models\Hsc\GroupSubject;
use App\Http\Controllers\Controller;

class GroupSubjectController extends Controller
{
    public function index(){
        $this->authorize('hsc.group-subject.view');
        $items = GroupSubject::OrderBy('group_id','asc')->get();
        $groups = Group::pluck('group_name','id');
        $groups = Group::pluck('group_name','id');
        $subjects = Subject::pluck('subject_name','id');
        $subjectTypes = GroupSubject::SUBJECT_GROUP_TYPE;
        return view('pages.hsc.subject-group.index', compact('items','groups','subjects','subjectTypes'));
    }

    public function store(Request $request){
        $this->authorize('hsc.group-subject.store');
        $type = $request->type;
        $req_is_common = $request->is_common ?? 0;
        $subject_ids = $request->subject_id;
        $name = $request->name;
        $group_id = $type == 'compulsory' ? null : $request->group_id;
        $is_common = $type == 'compulsory' ? 0 : $req_is_common;
        $is_main = $type == 'compulsory' ? 1 : 0;


        foreach($subject_ids as $subject_id){
            $groupSubject = new GroupSubject();
            $groupSubject->name = $name;
            $groupSubject->group_id = $group_id;
            $groupSubject->is_common = $is_common;
            $groupSubject->is_main = $is_main;
            $groupSubject->type = $type;
            $groupSubject->subject_id = $subject_id;
            $groupSubject->save();
        }

        return redirect()->back()->with('message','Subject Grouping Successfully Created');
    }

    public function edit($id){
        $this->authorize('hsc.group-subject.edit');
        $item = GroupSubject::find($id);
        $items = GroupSubject::OrderBy('group_id','asc')->get();
        $groups = Group::pluck('group_name','id');
        $groups = Group::pluck('group_name','id');
        $subjects = Subject::pluck('subject_name','id');
        $subjectTypes = GroupSubject::SUBJECT_GROUP_TYPE;
        return view('pages.hsc.subject-group.edit', compact('item', 'items','groups','subjects','subjectTypes'));
    }

    public function update(Request $request, $id){
        $this->authorize('hsc.group-subject.edit');
        $type = $request->type;
        $req_is_common = $request->is_common ?? 0;
        $subject_ids = $request->subject_id;
        $name = $request->name;
        $group_id = $type == 'compulsory' ? null : $request->group_id;
        $is_common = $type == 'compulsory' ? 0 : $req_is_common;
        $is_main = $type == 'compulsory' ? 1 : 0;


        foreach($subject_ids as $subject_id){
            $groupSubject = GroupSubject::find($id);
            $groupSubject->name = $name;
            $groupSubject->group_id = $group_id;
            $groupSubject->is_common = $is_common;
            $groupSubject->is_main = $is_main;
            $groupSubject->type = $type;
            $groupSubject->subject_id = $subject_id;
            $groupSubject->save();
        }

        return redirect()->route('group-subject.index')->with('message','Subject Grouping Successfully Updated');
    }

    public function destroy($id){
        $this->authorize('hsc.group-subject.delete');
        $groupSubject = GroupSubject::findOrFail($id);

        try {
            $groupSubject->delete();

            return redirect()
                ->route('group-subject.index')
                ->with('success', 'Subject Grouping successfully deleted.');
        } catch (\Exception $e) {
            return redirect()
                ->route('group-subject.index')
                ->with('error', 'Failed to delete Subject Grouping.');
        }
    }

}
