<?php

namespace App\Http\Controllers\Inventory;

use App\Services\Inventory\SalesService;
use App\Http\Controllers\Controller;
use App\Models\Inventory\Product;
use Illuminate\Http\Request;
class SalesController extends Controller
{
    protected $salesService;

    public function __construct(SalesService $salesService)
    {
        $this->salesService = $salesService;
    }

    public function index()
    {
        $sales = $this->salesService->getAllSales();
        return view('pages.inventory.sales.index', compact('sales'));
    }

    public function create()
    {
        $products = Product::orderBy('name','asc')->get();
        return view('pages.inventory.sales.create', compact('products'));
    }

    public function store(Request $request)
    {
        try {
            $sale = $this->salesService->createSale($request);
            return redirect()->route('sales.print', ['sale' => $sale->id]);
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function print($id)
    {
        $sale = $this->salesService->getSaleById($id);
        return view('pages.inventory.sales.print', compact('sale'));
    }


    public function show($id)
    {
        $sale = $this->salesService->getSaleById($id);
        return view('pages.inventory.sales.show', compact('sale'));
    }

    public function edit($id)
    {
        $sale = $this->salesService->getSaleById($id);
        return view('pages.inventory.sales.edit', compact('sale'));
    }

    public function update(Request $request, $id)   
    {
        try {
            $sale = $this->salesService->updateSale($request, $id);
            return redirect()->route('sales.print', ['sale' => $sale->id]);
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function destroy($id)
    {
        try {
            $this->salesService->deleteSale($id);
            return redirect()->route('sales.index')->with('success', 'Sale deleted successfully.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function search(Request $request)
    {
        $products = $this->salesService->searchProducts($request);
        return response()->json($products);
    }

    public function productSearch(Request $request)
    {
        $product = $this->salesService->productSearch($request);
        return response()->json($product);
    }

} 