<?php

namespace App\Http\Controllers\Library;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Library\Booklist;
use App\Models\Library\Bookmember;
use App\Models\Library\Bookissue;

class BookissueController extends Controller
{
    
    public function bookIssue($member_id){
        $member = Bookmember::findOrFail($member_id);
        $books = Booklist::all();
        $bookissueLists = Bookissue::where('bookmember_id',$member->id)->get();
        // dd($bookissueLists);
        return view('pages.library.book-issue.index',compact('member','books','bookissueLists'));
    }

    public function store(Request $request){
        $request->validate([
            'booklist_id' => 'required',
            'estimate_return_date' => 'required|date|after_or_equal:today',
        ]);
        $member = $request->bookmember_id;
        $existing_book_issue = Bookissue::where([['booklist_id',$request->booklist_id],['user_id',$request->user_id],['bookmember_id',$request->bookmember_id]])->get();

        // dd($existing_book_issue->count());

        if($existing_book_issue->count() == 0){
            $book = Booklist::find($request->booklist_id);
            // dd($request);
            if ($book->quantity > 0) {
                Bookissue::create([
                    'user_id' => $request->user_id,
                    'bookmember_id' => $request->bookmember_id,
                    'booklist_id' => $book->id,
                    'issue_date' => now(),
                    'estimate_return_date' => $request->estimate_return_date,
                    'status' => 'issued',
                    'created_by' => auth()->id(),
                ]);

                $book->decrement('quantity');
                return redirect()->route('book.issue',$member)->with('success', 'Book issue successfully.');
            }
            return redirect()->route('book.issue',$member)->with('error', 'No copies available.');
        }else{
            return redirect()->route('book.issue',$member)->with('error', 'Book already issued');
        }
    }

    public function bookReturn(Request $request){
        $bookissue = Bookissue::findOrFail($request->id);
        $bookissue->update(['return_date' => now(),'status'=>'returned']);
        $bookissue->booklist->increment('quantity');
        return redirect()->back()->with('success', 'Book returned successfully.');
    }
}
