<?php

namespace App\Http\Controllers\Library;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Library\Booklist;

class BooklistController extends Controller
{
    public function index(){
        $books = Booklist::all();
        return view('pages.library.booklist.index',compact('books'));
    }
    public function create(){
        return view('pages.library.booklist.create');
    }
    public function store(Request $request){
        $request->validate([
            'title' => 'required|string|max:255',
        ]);
        Booklist::create([
            'title' => $request->title,
            'book_number' => $request->book_number,
            'isbn_number' => $request->isbn_number,
            'publisher' => $request->publisher,
            'author' => $request->author,
            'subject' => $request->subject,
            'rack_number' => $request->rack_number,
            'quantity' => $request->quantity,
            'price' => $request->price,
            'postdate' => store_date_format($request->postdate),
            'description' => $request->description,
            'created_by' => auth()->id(),
        ]);
        return redirect()->route('booklist.index')->with('success', 'Book created successfully.');
    }
    public function edit($id){
        $book = Booklist::find($id);
        return view('pages.library.booklist.edit',compact('book'));
    }
    public function update(Request $request, $id){
        $request->validate([
            'title' => 'required|string|max:255',
        ]);
        Booklist::where('id',$id)->update([
            'title' => $request->title,
            'book_number' => $request->book_number,
            'isbn_number' => $request->isbn_number,
            'publisher' => $request->publisher,
            'author' => $request->author,
            'subject' => $request->subject,
            'rack_number' => $request->rack_number,
            'quantity' => $request->quantity,
            'price' => $request->price,
            'postdate' => store_date_format($request->postdate),
            'description' => $request->description,
            'created_by' => auth()->id(),
        ]);
        return redirect()->route('booklist.index')->with('success', 'Book updated successfully.');
    }

    public function destroy($id){
        $book = Booklist::find($id);
        $book->delete();
        return redirect()->route('booklist.index')->with('success', 'Book deleted successfully.');
    }

}
