<?php

namespace App\Http\Controllers\Library;

use App\Models\User;


use Illuminate\Http\Request;
use App\Models\Academic\Section;
use App\Models\Library\Bookmember;
use App\Http\Controllers\Controller;
use App\Models\Academic\StudentClass;
use Illuminate\Support\Facades\Response;

class BookmemberController extends Controller
{
    
    public function index(){
        $members = Bookmember::all();
        return view('pages.library.member.index',compact('members'));
    }
    public function create(){

        $student_class_id = '';
        $section_id = '';
        $studentClasses = StudentClass::pluck('class_name','id');
        $sections = Section::pluck('section_name','id');
        $user_types = User::select('user_type')->distinct()->get();
        return view('pages.library.member.create',compact('user_types','student_class_id','section_id','studentClasses','sections'));
    }

    public function userByType($user_type){
        $user = User::where('user_type',$user_type)->get();
        return Response::json($user);
    }

    public function store(Request $request){
        $request->validate([
            'user_type' => 'required|max:255',
            'name' => 'required|max:255',
            'member_ud_id' => 'required|unique:bookmembers|max:255',
        ]);
        Bookmember::create([
            'user_id' => $request->name,
            'member_ud_id' => $request->member_ud_id,
            'created_by' => auth()->id(),
        ]);
        return redirect()->route('bookmember.index')->with('success', 'Member created successfully.');
    }
}
