<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Devfaysal\BangladeshGeocode\Models\Division;
use Devfaysal\BangladeshGeocode\Models\District;
use Devfaysal\BangladeshGeocode\Models\Upazila;
use Devfaysal\BangladeshGeocode\Models\Union;
use Illuminate\Http\Request;

class LocationController extends Controller
{
    public function getDivisions()
    {
        $divisions = Division::all();
        return response()->json($divisions);
    }

    public function getDistricts(Request $request)
    {
        $districts = District::where('division_id', $request->division_id)->get();
        return response()->json($districts);
    }

    public function getUpazilas(Request $request)
    {
        $upazilas = Upazila::where('district_id', $request->district_id)->get();
        return response()->json($upazilas);
    }

    public function getUnions(Request $request)
    {
        $unions = Union::where('upazila_id', $request->upazila_id)->get();
        return response()->json($unions);
    }
} 