<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use App\Services\Reports\AccountingReportService;
use Illuminate\Http\Request;
use App\Traits\ReportExportTrait;
class AccountingReportController extends Controller
{
    use ReportExportTrait;
    protected AccountingReportService $accountingReportService;

    public function __construct(AccountingReportService $accountingReportService)
    {
        $this->accountingReportService = $accountingReportService;
    }

    public function index()
    {
        return view('report.accounting.index');
    }

    public function dailyCollection(Request $request) 
    {
        $data['dailyCollections'] = $this->accountingReportService->dailyCollection($request);
        return view('report.accounting.daily-collection', $data);
    }

    public function dailyCollectionExportExcel(Request $request)
    {
        $data = $this->accountingReportService->dailyCollectionWithColumns($request);
        $columns = ['invoice_date' => 'Date', 'total_amount' => 'Total Amount', 'total_discount' => 'Total Discount', 'total_late_fine' => 'Total Late Fine', 'total_paid' => 'Total Paid'];
        $options = ['filename' => 'daily-collections', 'title' => 'Fee Collection Report'];
        return $this->generateExport('excel', $data, ['columns' => $columns], $options);
    }

    public function dailyCollectionExportPDF(Request $request)
    {
        $data = $this->accountingReportService->dailyCollectionWithColumns($request);
        $columns = ['invoice_date' => 'Date', 'total_amount' => 'Total Amount', 'total_discount' => 'Total Discount', 'total_late_fine' => 'Total Late Fine', 'total_paid' => 'Total Paid'];
        $options = ['filename' => 'daily-collection', 'title' => 'Fee Collection Report'];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }  

    public function dailyCollectionExportPrint(Request $request)
    {
        $data = $this->accountingReportService->dailyCollectionWithColumns($request);
        $columns = ['invoice_date' => 'Date', 'total_amount' => 'Total Amount', 'total_discount' => 'Total Discount', 'total_late_fine' => 'Total Late Fine', 'total_paid' => 'Total Paid'];
        $options = ['filename' => 'daily-collection', 'title' => 'Fee Collection Report'];
        return $this->generateExport('print', $data, ['columns' => $columns], $options);
    }

    public function paymentDetailsReport(Request $request) 
    {
        $data = $this->accountingReportService->getRelatedData();
        $data['paymentDetails'] = $this->accountingReportService->paymentDetailsReport($request);
        $data['student_name'] = getStudentNameWithID($request->query('student_id_no'));
        return view('report.accounting.payment-details-report', $data);
    }

    public function paymentDetailsReportExportPDF(Request $request)
    {
        $data = $this->accountingReportService->paymentDetailsWithColumns($request);
        $columns = ['name' => 'Name', 'student_id_no' => 'Student ID', 'class_name' => 'Class', 'section_name' => 'Section', 'fee_title' => 'Fee', 'payment_date' => 'Payment Date', 'total_assigned_fee' => 'Total Assigned Fee', 'total_paid_fee' => 'Total Paid Fee', 'total_due_fee' => 'Total Due Fee'];
        $options = ['filename' => 'payment-details', 'title' => 'Payment Details Report'];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }

    public function paymentDetailsReportExportExcel(Request $request)
    {
        $data = $this->accountingReportService->paymentDetailsWithColumns($request);
        $columns = ['name' => 'Name', 'student_id_no' => 'Student ID', 'class_name' => 'Class', 'section_name' => 'Section', 'fee_title' => 'Fee', 'payment_date' => 'Payment Date', 'total_assigned_fee' => 'Total Assigned Fee', 'total_paid_fee' => 'Total Paid Fee', 'total_due_fee' => 'Total Due Fee'];
        $options = ['filename' => 'payment-details', 'title' => 'Payment Details Report'];
        return $this->generateExport('excel', $data, ['columns' => $columns], $options);
    }

    public function paymentDetailsReportExportPrint(Request $request)
    {
        $data = $this->accountingReportService->paymentDetailsWithColumns($request);
        $columns = ['name' => 'Name', 'student_id_no' => 'Student ID', 'class_name' => 'Class', 'section_name' => 'Section', 'fee_title' => 'Fee', 'payment_date' => 'Payment Date', 'total_assigned_fee' => 'Total Assigned Fee', 'total_paid_fee' => 'Total Paid Fee', 'total_due_fee' => 'Total Due Fee'];
        $options = ['filename' => 'payment-details', 'title' => 'Payment Details Report'];
        return $this->generateExport('print', $data, ['columns' => $columns], $options);
    }

    public function dueFeesReport(Request $request) 
    {
        $data = $this->accountingReportService->getRelatedData();
        $data['dueFees'] = $this->accountingReportService->getDueFeesReport($request);
        // dd($data);
        return view('report.accounting.due-fees', $data);
    }

    public function dueFeesReportExportPDF(Request $request)
    {
        $data = $this->accountingReportService->getDueFeesReportWithColumns($request);
        $columns = ['name' => 'Name', 'student_id_no' => 'Student ID', 'class_name' => 'Class', 'section_name' => 'Section', 'total_assigned_fee' => 'Total Assigned Fee', 'total_paid_fee' => 'Total Paid Fee', 'total_due_fee' => 'Total Due Fee'];
        $options = ['filename' => 'due-fees', 'title' => 'Due Fees Report'];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }

    public function dueFeesReportExportExcel(Request $request)
    {
        $data = $this->accountingReportService->getDueFeesReportWithColumns($request);
        $columns = ['name' => 'Name', 'student_id_no' => 'Student ID', 'class_name' => 'Class', 'section_name' => 'Section', 'total_assigned_fee' => 'Total Assigned Fee', 'total_paid_fee' => 'Total Paid Fee', 'total_due_fee' => 'Total Due Fee'];
        $options = ['filename' => 'due-fees', 'title' => 'Due Fees Report'];
        return $this->generateExport('excel', $data, ['columns' => $columns], $options);
    }

    public function dueFeesReportExportPrint(Request $request)
    {
        $data = $this->accountingReportService->getDueFeesReportWithColumns($request);
        $columns = ['name' => 'Name', 'student_id_no' => 'Student ID', 'class_name' => 'Class', 'section_name' => 'Section', 'total_assigned_fee' => 'Total Assigned Fee', 'total_paid_fee' => 'Total Paid Fee', 'total_due_fee' => 'Total Due Fee'];
        $options = ['filename' => 'due-fees', 'title' => 'Due Fees Report'];
        return $this->generateExport('print', $data, ['columns' => $columns], $options);
    }

    public function incomeReport(Request $request)
    {
        $data['incomes'] = $this->accountingReportService->getIncomeReport($request);
        return view('report.accounting.income-report', $data);
    }

    public function incomeReportExportExcel(Request $request)
    {
        $data = $this->accountingReportService->getIncomeReportWithColumns($request);
        $columns = ['income_date' => 'Date', 'accounting_head_name' => 'Accounting Head', 'total_amount' => 'Total Amount'];
        $options = ['filename' => 'income', 'title' => 'Income Report'];
        return $this->generateExport('excel', $data, ['columns' => $columns], $options);
    }

    public function incomeReportExportPDF(Request $request)
    {
        $data = $this->accountingReportService->getIncomeReportWithColumns($request);
        $columns = ['income_date' => 'Date', 'accounting_head_name' => 'Accounting Head', 'total_amount' => 'Total Amount'];
        $options = ['filename' => 'income', 'title' => 'Income Report'];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }

    public function incomeReportExportPrint(Request $request)
    {
        $data = $this->accountingReportService->getIncomeReportWithColumns($request);
        $columns = ['income_date' => 'Date', 'accounting_head_name' => 'Accounting Head', 'total_amount' => 'Total Amount'];
        $options = ['filename' => 'income', 'title' => 'Income Report'];
        return $this->generateExport('print', $data, ['columns' => $columns], $options);
    }

    public function expenseReport(Request $request)
    {
        $data['expenses'] = $this->accountingReportService->getExpenseReport($request);
        return view('report.accounting.expense-report', $data);
    }

    public function expenseReportExportExcel(Request $request)
    {
        $data = $this->accountingReportService->getExpenseReportWithColumns($request);
        $columns = ['expense_date' => 'Date', 'accounting_head_name' => 'Accounting Head', 'total_amount' => 'Total Amount'];
        $options = ['filename' => 'expense', 'title' => 'Expense Report'];
        return $this->generateExport('excel', $data, ['columns' => $columns], $options);
    }

    public function expenseReportExportPDF(Request $request)
    {
        $data = $this->accountingReportService->getExpenseReportWithColumns($request);
        $columns = ['expense_date' => 'Date', 'accounting_head_name' => 'Accounting Head', 'total_amount' => 'Total Amount'];
        $options = ['filename' => 'expense', 'title' => 'Expense Report'];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }

    public function expenseReportExportPrint(Request $request)
    {
        $data = $this->accountingReportService->getExpenseReportWithColumns($request);
        $columns = ['expense_date' => 'Date', 'accounting_head_name' => 'Accounting Head', 'total_amount' => 'Total Amount'];
        $options = ['filename' => 'expense', 'title' => 'Expense Report'];
        return $this->generateExport('print', $data, ['columns' => $columns], $options);
    }
    
    public function payrollReport(Request $request)
    {
        list($data['newSalaries'], $data['salary_heads']) = $this->accountingReportService->getSalaryReport($request);
        return view('report.accounting.payroll-report', $data);
    }

    public function incomeExpenseSummary(Request $request)
    {
        // Get income and expense data, including totals
        $data['incomes'] = $this->accountingReportService->getDateWiseIncome($request);
        $data['expenses'] = $this->accountingReportService->getDateWiseExpense($request);
    
        // Include the total sums in the data for display
        $data['totalIncome'] = $data['incomes']['totalIncome'];
        $data['totalExpense'] = $data['expenses']['totalExpense'];
    
        return view('report.accounting.income-expense-summary', $data);
    }

    //income expense headwise report
    public function incomeExpenseHeadwiseReport(Request $request)
    {
        $data['incomes'] = $this->accountingReportService->getIncomeHeadwiseReport($request);
        $data['expenses'] = $this->accountingReportService->getExpenseHeadwiseReport($request);
        return view('report.accounting.income-expense-headwise-report', $data);
    }
    
}
