<?php

namespace App\Http\Controllers\Report;

use PDF;
use App\Models\Result\Exam;
use Illuminate\Http\Request;
use App\Models\Academic\Shift;
use App\Traits\ReportExportTrait;
use App\Http\Controllers\Controller;
use App\Services\ExamResult\MarksEntryService;
use App\Services\Reports\ExamResultReportService;
    
class ExamResultReportController extends Controller
{
    use ReportExportTrait;
    protected ExamResultReportService $examResultReportService;
    protected MarksEntryService $marksEntryService;


    public function __construct(ExamResultReportService $examResultReportService, MarksEntryService $marksEntryService)
    {
        $this->examResultReportService = $examResultReportService;
        $this->marksEntryService = $marksEntryService;
    }



    public function index()
    {
        return view('report.exam-result.index');
    }

    public function classRankReport(Request $request)
    {
        $data = $this->examResultReportService->getRelatedData();
        $data['exams'] = Exam::orderBy('id', 'desc')->select('id', 'exam_name', 'year')->get();
        $data['shifts'] = Shift::select('id', 'shift_name')->get();
        $data['title'] = 'Class Rank Report';
        $data['exam_id'] = $request->exam_id ?? '';
        $data['shift_id'] = $request->shift_id ?? 'null';
        $data['student_class_id'] = $request->student_class_id ?? 'null';
        $data['section_id'] = $request->section_id ?? null;
        $data['group_id'] = $request->group_id ?? null;
        list($data['students'], $data['assignedMarksHead'], $data['highest_marks_array'],  $data['subjects_assigns']) = $this->examResultReportService->classRankReport($request);
        
        // dd($data,count($data['students']), count($data['assignedMarksHead']), count($data['subjects_assigns']));
        return view('report.exam-result.class-rank-report', $data);
    }

    public function AllMarkSheetDownload(Request $request){
        $data = $this->marksEntryService->getRelatedData();
        list($data['students'], $data['highest_marks_array'], $data['assignedMarksHead'], $data['publish_date'], $data['subjects_assigns']) 
        = $this->marksEntryService->AllMarkSheetDownload($request);
        $data['exam'] = Exam::where('id', $request->exam_id)->first();
        // dd($data);   
        return view('report.exam-result.all-mark-sheet', $data);
    }
    public function individuleMarkSheetDownload(Request $request){


        // $data = $this->marksEntryService->getRelatedData();
        // list($data['students'], $data['highest_marks_array'], $data['assignedMarksHead'], $data['publish_date'], $data['subjects_assigns']) = $this->marksEntryService->getMarksSheetByClass($request);

        // $columns = ['student_name', 'class_roll', 'total_marks'];

        // $options = [
        //     'filename' => 'marks-sheet',
        //     'title' => 'Marks Sheet',
        //     'orientation' => 'portrait',
        //     'view' => 'pages.result.marks_sheet.mark_sheet_pdf',
        //     'paper_size' => 'a4'
        // ];

        // $data['request'] = $request;
        // return $this->generateExport('pdf', $data, ['columns' => $columns], $options);


        
        $data = $this->marksEntryService->getRelatedData();
        list($data['students'], $data['highest_marks_array'], $data['assignedMarksHead'], $data['publish_date'], $data['subjects_assigns']) = $this->marksEntryService->individuleMarkSheetDownload($request);
        $data['exam'] = Exam::where('id', $request->exam_id)->first();
         // Generate PDF using a view

        // dd($data);
        // $pdf = Pdf::loadView('report.exam-result.individule-mark-sheet', [
        //     'data' => $data,
        //     'report_title' => 'Student Mark Sheet'
        // ]);
        // // Return the PDF for download as a blob
        // $fileName = $request->student_id ?? date("dmY");

        // return response($pdf->output(), 200)
        // ->header('Content-Type', 'application/pdf')
        // ->header('Content-Disposition', 'inline; filename="student-mark-sheet-' . $fileName . '.pdf"');


        // return response($pdf->output(), 200)
        //     ->header('Content-Type', 'application/pdf')
        //     ->header('Content-Disposition', 'attachment; filename="student-mark-sheet.pdf"');

        // dd($request->all(), $data);

        return view('report.exam-result.individule-mark-sheet', $data);


    }

    public function classRankReportPDF(Request $request)
    {
        $data = $this->examResultReportService->getRelatedData();
        list($data['students'], $data['assignedMarksHead'], $data['highest_marks_array']) = $this->examResultReportService->classRankReport($request);
        return view('report.exam-result.class-rank-report-pdf', $data);
    }

    public function classRankReportPrint(Request $request)
    {
        $data = $this->examResultReportService->getRelatedData();
        list($data['students'], $data['assignedMarksHead'], $data['highest_marks_array']) = $this->examResultReportService->classRankReport($request);
        $options = [
            'filename' => 'marks-sheet',
            'title' => 'Marks Sheet',
            'orientation' => 'landscape',
            'view' => 'report.exam-result.class-rank-report-print',
            'paper_size' => 'a4'
        ];
 
        return $this->generateExport('print', $data, ['columns' => []], $options);
    }

    public function classGPAReport(Request $request)
    {
        $data = $this->examResultReportService->getRelatedData();
        list($data['students'], $data['assignedMarksHead']) = $this->examResultReportService->classRankReport($request);
        return view('report.exam-result.class-gpa-report', $data);
    }
}
