<?php

namespace App\Http\Controllers\Report;

use Illuminate\Http\Request;
use App\Models\Academic\Branch;
use App\Models\HrPayroll\Employee;
use App\Models\Student\StudentInfo;
use App\Http\Controllers\Controller;
use App\Models\Scopes\BranchFilterScope;
use App\Services\Reports\MultiBranchReportService;

class MultiBranchReportController extends Controller
{
    protected $multiBranchReportService;

    public function __construct(MultiBranchReportService $multiBranchReportService)
    {
        $this->multiBranchReportService = $multiBranchReportService;
    }

    public function index()
    {
        $data['branches'] = Branch::all();
        $data['total_students'] = StudentInfo::withoutGlobalScope(BranchFilterScope::class)->whereNotNull('branch_id')->count();
        $data['total_teachers'] = Employee::withoutGlobalScope(BranchFilterScope::class)->where('user_type', 'teacher')->count();
        $data['total_employees'] = Employee::withoutGlobalScope(BranchFilterScope::class)->whereNotNull('branch_id')->count(); 
        $data['todays_collection'] = $this->multiBranchReportService->getTodaysTotalCollection();
        $data['todays_income'] = $this->multiBranchReportService->getTodaysTotalIncome();
        $data['todays_expense'] = $this->multiBranchReportService->getTodaysTotalExpense();
        $data['total_income'] = $this->multiBranchReportService->getTotalIncome();
        $data['total_expense'] = $this->multiBranchReportService->getTotalExpense();
        $data['total_collection'] = $this->multiBranchReportService->getTotalCollection();
        $data['branchIncomeSummary'] = $this->multiBranchReportService->getBranchIncomeSummary();
        $data['branchExpenseSummary'] = $this->multiBranchReportService->getBranchExpenseSummary();
        $data['title'] = 'Multi Branch Report';
        // dd($data);
        return view('report.multi-branch.index', $data);
    }

    public function totalCollection(Request $request)
    {
        $data = $this->multiBranchReportService->getTotalCollectionReport($request);
        $data['title'] = 'Branch Wise Total Collection';
        return view('report.multi-branch.total-collection', $data);
    }

    public function incomeReport(Request $request)
    {
        $data = $this->multiBranchReportService->getIncomeReport($request);
        $data['title'] = 'Branch Wise Income';
        return view('report.multi-branch.income-report', $data);
    }

    public function expenseReport(Request $request)
    {
        $data = $this->multiBranchReportService->getExpenseReport($request);
        $data['title'] = 'Branch Wise Expense';
        return view('report.multi-branch.expense-report', $data);
    }
}
