<?php

namespace App\Http\Controllers\Report;

use App\Models\Result\Exam;
use App\Models\Result\Grade;
use Illuminate\Http\Request;
use App\Models\Academic\Group;
use App\Models\Academic\Shift;
use App\Models\Result\MarkHead;
use App\Models\Academic\Section;
use App\Models\Result\ExamRecord;
use Illuminate\Support\Facades\DB;
use App\Models\Student\StudentInfo;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicYear;
use App\Models\Academic\StudentClass;
use App\Models\Result\MarkHeadAssign;
use App\Models\Academic\SubjectsAssign;

class ResultReportController extends Controller
{
    public function resultReportIndex()
    {
        $exam_id = '';
        $academic_year = '';
        $shift_id = '';
        $section_id = '';
        $group_id = '';
        $student_class_id = '';
        $subject_id = '';
        $studentClasses = StudentClass::pluck('class_name','id');
        $groups = Group::pluck('group_name', 'id');
        $sections = Section::pluck('section_name','id');
        $grades = Grade::all();
        $academicYears = AcademicYear::orderBy('year','DESC')->pluck('year','id');
        $exams = Exam::orderBy('id', 'desc')->select('id', 'exam_name', 'year')->get();
        $shifts = Shift::select('id', 'shift_name')->get();

        return view('report.exam-result.result_report', compact('grades', 'exams', 'studentClasses', 'groups', 'shifts', 'sections', 'academicYears', 'exam_id', 'academic_year', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'subject_id'));
    }

    public function getMarksResultByClass_old(Request $request){
        $exam_id = $request->exam_id;
        $academic_year = $request->academic_year;
        $shift_id = $request->shift_id;

        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $student_class_id = $request->student_class_id;

        $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)->where('student_class_id', $student_class_id)->pluck('head_marks', 'subject_id');

        $students = StudentInfo::where('student_class_id', $student_class_id);
        if (!empty($shift_id)) {
            $students->where('shift_id', $shift_id);
        }
        if (!empty($section_id)) {
            $students->where('section_id', $section_id);
        }
        if (!empty($group_id)) {
            $students->where('group_id', $group_id);
        }

        // Only fetch students who have related exam records for the given exam and class
        $students = $students->whereHas('examRecords', function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id);
        })->with(['examRecords.subject', 'examRecords' => function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id)
                ->orderBy('subject_id');
        }])->orderBy('class_roll', 'ASC')->get();

        // Query for the highest marks, again applying conditions fluently
        $highestMarks = ExamRecord::where('class_id', $student_class_id)
            ->where('exam_id', $exam_id)
            ->when(!empty($shift_id), function ($query) use ($shift_id) {
                $query->where('shift_id', $shift_id);
            })
            ->when(!empty($section_id), function ($query) use ($section_id) {
                $query->where('section_id', $section_id);
            })
            ->when(!empty($group_id), function ($query) use ($group_id) {
                $query->where('group_id', $group_id);
            })
            ->groupBy('subject_id')
            ->select('subject_id', DB::raw('MAX(total_marks) as highest_marks'))
            ->get();

        $highest_marks_array = [];
        foreach ($highestMarks as $marks) {
            $highest_marks_array[$marks->subject_id] = $marks->highest_marks;
        }

        $studentClasses = StudentClass::pluck('class_name','id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name','id');

        $academicYears = AcademicYear::pluck('year','id');
        $exams = Exam::pluck('exam_name','id');
        $markHeads = MarkHead::all();
        $grades = Grade::all();
        $publish_date = Exam::where('id', $exam_id)->first()->publish_date;
        return view('report.exam-result.result_report', compact('students', 'grades', 'exams', 'assignedMarksHead', 'studentClasses', 'groups', 'shifts', 'sections', 'academicYears', 'markHeads', 'exam_id', 'academic_year', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'publish_date', 'highest_marks_array'));
    }



    public function getMarksResultByClass(Request $request)
    {
        $exam_id = $request->exam_id;
        $academic_year = Exam::where('id', $exam_id)->first()->year;
        $shift_id = $request->shift_id;

        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $student_class_id = $request->student_class_id;

        $subjects_assigns = SubjectsAssign::where('student_class_id',$student_class_id)->select('id','student_class_id','subject_id')->get();
        
        $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)->where('student_class_id', $student_class_id)->pluck('head_marks', 'subject_id');

        $students = StudentInfo::where('student_class_id', $student_class_id)->where('status','active');
        
        if (!empty($shift_id)) {
            $students->where('shift_id', $shift_id);
        }
        if (!empty($section_id)) {
            $students->where('section_id', $section_id);
        }
        if (!empty($group_id)) {
            $students->where('group_id', $group_id);
        }

        // Only fetch students who have related exam records for the given exam and class
        $students = $students->whereHas('examRecords', function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id);
        })->with(['examRecords.subject', 'examRecords' => function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id)
                ->orderBy('subject_id');
        }])->orderBy('class_roll', 'ASC')->get();

        // Query for the highest marks, again applying conditions fluently
        $highestMarks = ExamRecord::where('class_id', $student_class_id)
            ->where('exam_id', $exam_id)
            ->when(!empty($shift_id), function ($query) use ($shift_id) {
                $query->where('shift_id', $shift_id);
            })
            ->when(!empty($section_id), function ($query) use ($section_id) {
                $query->where('section_id', $section_id);
            })
            ->when(!empty($group_id), function ($query) use ($group_id) {
                $query->where('group_id', $group_id);
            })
            ->groupBy('subject_id')
            ->select('subject_id', DB::raw('MAX(total_marks) as highest_marks'))
            ->get();

        $highest_marks_array = [];
        foreach ($highestMarks as $marks) {
            $highest_marks_array[$marks->subject_id] = $marks->highest_marks;
        }

        $studentClasses = StudentClass::pluck('class_name','id');
        $groups = Group::pluck('group_name', 'id');
        $sections = Section::pluck('section_name','id');

        $academicYears = AcademicYear::pluck('year','id');
        $exams = Exam::orderBy('id', 'desc')->select('id', 'exam_name', 'year')->get();
        $shifts = Shift::select('id', 'shift_name')->get();

        $markHeads = MarkHead::all();
        $grades = Grade::all();
        $publish_date = Exam::where('id', $exam_id)->first()->publish_date;
        $total_grade_count_arr = Grade::pluck('name', 'id');
        // dd($students);
        return view('report.exam-result.result_report', compact('subjects_assigns', 'students', 'grades', 'total_grade_count_arr', 'exams', 'assignedMarksHead', 'studentClasses', 'groups', 'shifts', 'sections', 'academicYears', 'markHeads', 'exam_id', 'academic_year', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'publish_date', 'highest_marks_array'));
    }

    public function gradeCount()
    {

        $exam_id = '';
        $academic_year = '';
        $shift_id = '';
        $section_id = '';
        $group_id = '';
        $student_class_id = '';
        $subject_id = '';
        $studentClasses = StudentClass::pluck('class_name','id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name','id');
        $grades = Grade::all();
        $academicYears = AcademicYear::orderBy('year','DESC')->pluck('year','id');
        $exams = Exam::pluck('exam_name','id');
        $total_grade_count_arr = Grade::pluck('name', 'id');
        return view('report.exam-result.countGradeByClass', compact('grades', 'exams', 'studentClasses', 'groups', 'total_grade_count_arr', 'shifts', 'sections', 'academicYears', 'exam_id', 'academic_year', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'subject_id'));
    }

    public function countGradeByClassOLD(Request $request){
        $exam_id = $request->exam_id;
        $academic_year = $request->academic_year;
        $shift_id = $request->shift_id;

        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $student_class_id = $request->student_class_id;
        $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)->where('student_class_id', $student_class_id)->pluck('head_marks', 'subject_id');

        $students = StudentInfo::where('student_class_id', $student_class_id);
        if (!empty($shift_id)) {
            $students->where('shift_id', $shift_id);
        }
        if (!empty($section_id)) {
            $students->where('section_id', $section_id);
        }
        if (!empty($group_id)) {
            $students->where('group_id', $group_id);
        }

        // Only fetch students who have related exam records for the given exam and class
        $students = $students->whereHas('examRecords', function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id);
        })->with(['examRecords.subject', 'examRecords' => function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id)
                ->orderBy('subject_id');
        }])->orderBy('class_roll', 'ASC')->get();

        // Query for the highest marks, again applying conditions fluently
        $highestMarks = ExamRecord::where('class_id', $student_class_id)
            ->where('exam_id', $exam_id)
            ->when(!empty($shift_id), function ($query) use ($shift_id) {
                $query->where('shift_id', $shift_id);
            })
            ->when(!empty($section_id), function ($query) use ($section_id) {
                $query->where('section_id', $section_id);
            })
            ->when(!empty($group_id), function ($query) use ($group_id) {
                $query->where('group_id', $group_id);
            })
            ->groupBy('subject_id')
            ->select('subject_id', DB::raw('MAX(total_marks) as highest_marks'))
            ->get();

        $highest_marks_array = [];
        foreach ($highestMarks as $marks) {
            $highest_marks_array[$marks->subject_id] = $marks->highest_marks;
        }

        $studentClasses = StudentClass::pluck('class_name','id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name','id');

        $academicYears = AcademicYear::pluck('year','id');
        $exams = Exam::pluck('exam_name','id');
        $markHeads = MarkHead::all();
        $grades = Grade::all();
        $publish_date = Exam::where('id', $exam_id)->first()->publish_date;
        $shift_name = Shift::where('id', $shift_id)->first()->shift_name;
        $total_grade_count_arr = Grade::pluck('name', 'id');
        return view('report.exam-result.countGradeByClass', compact('students', 'grades', 'total_grade_count_arr', 'exams', 'assignedMarksHead', 'studentClasses', 'groups', 'shifts','shift_name', 'sections', 'academicYears', 'markHeads', 'exam_id', 'academic_year', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'publish_date', 'highest_marks_array'));
    }

    public function countGradeByClass(Request $request){

        dd("This is the result report index page.");
        $exam_id = $request->exam_id;
        $academic_year = $request->academic_year;
        $shift_id = $request->shift_id;

        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $student_class_id = $request->student_class_id;
        $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)->where('student_class_id', $student_class_id)->pluck('head_marks', 'subject_id');

        $students = StudentInfo::where('student_class_id', $student_class_id);
        if (!empty($shift_id)) {
            $students->where('shift_id', $shift_id);
        }
        if (!empty($section_id)) {
            $students->where('section_id', $section_id);
        }
        if (!empty($group_id)) {
            $students->where('group_id', $group_id);
        }

        // Only fetch students who have related exam records for the given exam and class
        $students = $students->whereHas('examRecords', function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id);
        })->with(['examRecords.subject', 'examRecords' => function ($query) use ($exam_id, $academic_year, $student_class_id) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year)
                ->where('class_id', $student_class_id)
                ->orderBy('subject_id');
        }])->orderBy('class_roll', 'ASC')->get();

        // Query for the highest marks, again applying conditions fluently
        $highestMarks = ExamRecord::where('class_id', $student_class_id)
            ->where('exam_id', $exam_id)
            ->when(!empty($shift_id), function ($query) use ($shift_id) {
                $query->where('shift_id', $shift_id);
            })
            ->when(!empty($section_id), function ($query) use ($section_id) {
                $query->where('section_id', $section_id);
            })
            ->when(!empty($group_id), function ($query) use ($group_id) {
                $query->where('group_id', $group_id);
            })
            ->groupBy('subject_id')
            ->select('subject_id', DB::raw('MAX(total_marks) as highest_marks'))
            ->get();

        $highest_marks_array = [];
        foreach ($highestMarks as $marks) {
            $highest_marks_array[$marks->subject_id] = $marks->highest_marks;
        }

        $studentClasses = StudentClass::pluck('class_name','id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name','id');

        $academicYears = AcademicYear::pluck('year','id');
        $exams = Exam::pluck('exam_name','id');
        $markHeads = MarkHead::all();
        $grades = Grade::all();
        $publish_date = Exam::where('id', $exam_id)->first()->publish_date;
        $shift_name = Shift::where('id', $shift_id)->first()->shift_name;
        $total_grade_count_arr = Grade::pluck('name', 'id');
        return view('report.exam-result.countGradeByClass', compact('students', 'grades', 'total_grade_count_arr', 'exams', 'assignedMarksHead', 'studentClasses', 'groups', 'shifts','shift_name', 'sections', 'academicYears', 'markHeads', 'exam_id', 'academic_year', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'publish_date', 'highest_marks_array'));
    }


}
