<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use App\Models\Academic\Section;
use App\Models\Academic\StudentClass;
use App\Services\Reports\StudentReportService;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Traits\ReportExportTrait;
class StudentReportController extends Controller
{
    use ReportExportTrait;
    protected StudentReportService $studentReportService;

    public function __construct(StudentReportService $studentReportService)
    {
        $this->studentReportService = $studentReportService;
    }

    public function index()
    {
        return view('report.students.index');
    }

    
    public function informationReport(Request $request)
    {

        $data = $this->studentReportService->getRelatedData();

        if ($request->ajax()) {
            if (!empty($request->query())) {
                $students = $this->studentReportService->getStudentReport($request->query());
            } else {
                $students = collect();
            }

            return DataTables::of($students)->make(true);
        }

        if (!empty($request->query())) {
            $data['students'] = $this->studentReportService->getStudentReport($request->query());
        } else {
            $data['students'] = collect();
        }

        return view('report.students.information-report', $data);
    }

    public function classSectionReport()
    {
        $data = $this->studentReportService->getRelatedData();
        $data['students'] = $this->studentReportService->getClassSectionReport();
        return view('report.students.class-section-report', $data);
    }


    public function siblingReport(Request $request)
    {
        $data = $this->studentReportService->getRelatedData();
        $data['students'] = $this->studentReportService->getSiblingReport($request->query());
        return view('report.students.sibling-report', $data);
    }

    public function informationReportExportExcel(Request $request)
    {
        $data = $this->studentReportService->getStudentReportWithColumns($request->all());
        $columns = $request->input('selected_columns', []);
        $options = ['filename' => 'student-information', 'title' => 'Student Information Report'];
        return $this->generateExport('excel', $data, ['columns' => $columns], $options);
    }

    public function informationReportExportPDF(Request $request)
    {
        $data = $this->studentReportService->getStudentReportWithColumns($request->all());
        $columns = $request->input('selected_columns', []);
        $options = ['filename' => 'student-information', 'title' => 'Student Information Report'];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }

    public function informationReportExportPrint(Request $request)
    {
        $requestData = $request->except('selected_columns');
        $data = $this->studentReportService->getStudentReportWithColumns($requestData);
        $columns = json_decode($request->input('selected_columns', []), true);
        $class_name = StudentClass::find($request->input('student_class'))?->class_name ?? '--';
        $section_name = Section::find($request->input('section'))?->section_name ?? '--';
        $options = [
            'title' => 'Student Information Report',
            'subtitle' => "Class: {$class_name}, Section: {$section_name}"
        ];
        // dd($requestData , $data, $columns, $options);
        return $this->generatePrintView($data, ['columns' => $columns], $options);
    }

    public function classSectionReportExportPDF()
    {
        $data = $this->studentReportService->getClassSectionReportWithColumns();
        $columns = [
            'sn' => 'SN', 
            'class_name' => 'Class', 
            'section_name' => 'Section', 
            'shift_name' => 'Shift',
            'total_students' => 'Total Student', 
        ];

        $title = 'Class Section Report';
        $subtitle = 'Total Students: ' . $data->grand_total;
        $options = ['filename' => 'class-section-report', 'title' => $title, 'subtitle' => $subtitle];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }

    public function classSectionReportExportPrint()
    {
        $data = $this->studentReportService->getClassSectionReportWithColumns();
        $columns = [
            'sn' => 'SN', 
            'class_name' => 'Class', 
            'section_name' => 'Section', 
            'shift_name' => 'Shift',
            'total_students' => 'Total Student', 
        ];
        $options = ['title' => 'Class Section Report', 'subtitle' => 'Total Students: ' . $data->grand_total];
        return $this->generatePrintView($data, ['columns' => $columns], $options);
    }

    public function siblingReportExportPDF(Request $request)
    {
        $data = $this->studentReportService->getSiblingReportWithColumns($request->all());
        $columns = $request->input('selected_columns', []);
        $options = ['filename' => 'sibling-report', 'title' => 'Sibling Report'];
        return $this->generateExport('pdf', $data, ['columns' => $columns], $options);
    }

    public function siblingReportExportPrint(Request $request)
    {
        $requestData = $request->except('selected_columns');
        $data = $this->studentReportService->getSiblingReportWithColumns($requestData);
        $columns = json_decode($request->input('selected_columns', []), true);
        $options = ['title' => 'Sibling Report'];
        return $this->generatePrintView($data, ['columns' => $columns], $options);
    }
}
