<?php

namespace App\Http\Controllers\Report;

use Illuminate\Http\Request;

use App\Models\Academic\StudentClass;
use App\Http\Controllers\Controller;
use App\Models\Academic\Subject;
use App\Models\Syllabus\Lesson;
use App\Models\Result\Exam;
use PDF;

class SyllabusReportController extends Controller{
    public function index(){
        return view('report.syllabus.index');
    }
    public function syllabusStatus(){
        $exam_id = '';
        $student_class_id = '';
        $subject_id = '';
        $exams = Exam::pluck('exam_name','id');
        $studentClasses = StudentClass::pluck('class_name','id');
        $subject = Subject::pluck('subject_name','id');
        $lessons = null;
        $exam_name = null;
        $class_name = null;
        return view('report.syllabus.syllabus-status-report', compact('lessons','exam_name','class_name','exams','studentClasses','subject','exam_id','student_class_id', 'subject_id'));
    }
    public function syllabusStatusSearch(Request $request){
        $exam_id = $request->exam_id;
        $student_class_id = $request->student_class;
        $subject_id = $request->subject_id;
        $exams = Exam::pluck('exam_name','id');
        $studentClasses = StudentClass::pluck('class_name','id');
        $subject = Subject::pluck('subject_name','id');
        $exam_name = Exam::findOrFail($exam_id)->exam_name;
        $class_name = StudentClass::findOrFail($student_class_id)->class_name; 
        
        $lessons = Lesson::query();
        if($request->has('exam_id')){
            $lessons->where('exam_id', $exam_id);
        }
        if($request->has('student_class')){
            $lessons->where('student_class_id', $student_class_id);
        }
        if (!empty($subject_id)) {
            $lessons->where('subject_id', $subject_id);
        }
        $lessons = $lessons->with('lessonTopics')->get();
        // dd($lessons);
        return view('report.syllabus.syllabus-status-report', compact('lessons','exam_name','class_name','exams','studentClasses','subject','exam_id','student_class_id', 'subject_id'));
    }
    public function pdfExport(Request $request)
    {
        $exam_id = $request->exam_id;
        $student_class_id = $request->student_class_id;
        $subject_id = $request->subject_id;

        // Query and fetch data for PDF generation
        $lessons = Lesson::query();

        if ($request->has('exam_id')) {
            $lessons->where('exam_id', $exam_id);
        }

        if ($request->has('student_class_id')) {
            $lessons->where('student_class_id', $student_class_id);
        }

        if (!empty($subject_id)) {
            $lessons->where('subject_id', $subject_id);
        }

        $lessons = $lessons->with('lessonTopics')->get();

        if ($lessons->isEmpty()) {
            return response()->json(['error' => 'No content available for the selected filters'], 204);
        }

        $exam_name = Exam::findOrFail($exam_id)->exam_name;
        $class_name = StudentClass::findOrFail($student_class_id)->class_name;

        // Generate PDF using a view
        $pdf = Pdf::loadView('report.syllabus.pdf', [
            'lessons' => $lessons,
            'exam_name' => $exam_name,
            'class_name' => $class_name,
            'report_title' => 'Syllabus Status Report'
        ]);

        // Return the PDF for download as a blob
        return response($pdf->output(), 200)
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'attachment; filename="syllabus-status-report.pdf"');
    }

    public function pdfExport22(Request $request){
        $exam_id = $request->exam_id;
        $student_class_id = $request->student_class_id;
        $subject_id = $request->subject_id;
        $exams = Exam::pluck('exam_name','id');
        $studentClasses = StudentClass::pluck('class_name','id');
        $subject = Subject::pluck('subject_name','id');
        $exam_name = Exam::findOrFail($exam_id)->exam_name;
        $class_name = StudentClass::findOrFail($student_class_id)->class_name; 

        $lessons = Lesson::query();
        if($request->has('exam_id')){
            $lessons->where('exam_id', $exam_id);
        }
        if($request->has('student_class_id')){
            $lessons->where('student_class_id', $student_class_id);
        }
        if (!empty($subject_id)) {
            $lessons->where('subject_id', $subject_id);
        }
        $lessons = $lessons->with('lessonTopics')->get();
        // Check if lessons exist, if not return a response
        if ($lessons->isEmpty()) {
            return response()->json(['error' => 'No content available for the selected filters'], 204);
        }
        // Generate PDF if lessons are found
        $pdf = Pdf::loadView('report.syllabus.pdf', [
            'lessons' => $lessons,
            'exam_name' => $exam_name,
            'class_name' => $class_name,
            'report_title' => 'Syllabus Status Report'
        ]);

        // Return the PDF for download
        return response()->streamDownload(function () use ($pdf) {
            echo $pdf->stream();
        }, 'syllabus_report.pdf', [
            'Content-Type' => 'application/pdf',
        ]);

        // if(!empty($lessons)){
        //     $pdf = Pdf::loadView('report.syllabus.pdf', ['lessons'=>$lessons,'exam_name'=>$exam_name,'class_name'=>$class_name,'report_title'=>'Syllabus Status Report']);

        //     return response()->streamDownload(function () use ($pdf) {
        //         echo $pdf->stream();
        //     }, 'users.pdf', [
        //         'Content-Type' => 'application/pdf',
        //     ]);
        // }
    }
} 