<?php

namespace App\Http\Controllers\Report;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use App\Models\Attendance\StudentAttendance;

class TodaysReportController extends Controller
{

    public function todaysStudentAttendance()
    {
        $today = Carbon::today()->format('Y-m-d');
        $today = '2026-01-30';
        $attendances = StudentAttendance::with(['studentInfo:id,student_id_no,name'])
        ->where('branch_id',auth()->user()->branch_id)->whereDate('punch_date', $today)
        ->where('day_status', 'P')
            ->select('id','student_id','student_class_id','shift_id','day_status', 'is_present')->get();
        // dd($today, $attendances);
        return view('report.todays.student_attendance',compact('attendances'));
    }

    public function todaysStudentAbsent()
    {
        $today = Carbon::today()->format('Y-m-d');
        $today = '2026-01-30';
        $absentStudents = StudentAttendance::with(['studentInfo:id,student_id_no,name'])->where('branch_id',auth()->user()->branch_id)->whereDate('punch_date', $today)
            ->where('day_status', 'A')
            ->select('id', 'student_id', 'student_class_id', 'shift_id', 'day_status', 'is_absent')
            ->get();
        // dd($today, $absentStudents);
        return view('report.todays.student_absent', compact('absentStudents'));
    }
}
