<?php

namespace App\Http\Controllers\Report;

use PDF;
use App\Constants\Settings;
use Illuminate\Http\Request;
use App\Exports\TranspoerExport;
use App\Models\Student\StudentInfo;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Transport\TransportRoute;
use Yajra\DataTables\Facades\DataTables;
use App\Models\Transport\StudentTransport;

class TransportReportController extends Controller
{
    protected $institute_name;

    public function __construct()
    {
        $this->institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
    }

    public function index(){
        return view('report.transport.index');
    }

    public function routeWiseStudent(){
        $route_id = '';
        $stoppage_id = '';
        $transport_routes = TransportRoute::pluck('route_name','id');
        return view('report.transport.route-wise-student-report', compact('route_id','stoppage_id','transport_routes'));
    }

    public function routeWiseStudentSearch(Request $request){
        // Custom validation for at least one required field
        // $request->validate([
        //     'route_id' => 'nullable|required_without_all:stoppage_id,student_id',
        //     'stoppage_id' => 'nullable|required_without_all:route_id,student_id',
        //     'student_id' => 'nullable|required_without_all:route_id,stoppage_id|array|min:1',
        // ]);
        // $route_id = $request->input('route_id');
        // $stoppage_id = $request->input('stoppage_id');
        // $student_id = $request->input('student_id');


        // dd($route_id,$stoppage_id,$student_id);

        try {
            $route_id = $request->input('route_id');
            $stoppage_id = $request->input('stoppage_id');
            $student_id = $request->input('student_id');
            // Fetch the selected columns or set defaults
            $selectedColumns = $request->input('selected_columns', []);
            if (empty($selectedColumns)) {
                $selectedColumns = ['student_id','route_id','stoppage_id','monthly_cost'];
            }

            // Always include necessary columns
            $requiredColumns = ['student_id','route_id'];
            $selectColumns = array_unique(array_merge($selectedColumns, $requiredColumns));
            $columns = array_diff($selectColumns,['student_name','student_class','guardian_name','guardian_contact']);

            // Build the query
            if(!empty($stoppage_id)){
                $data = StudentTransport::select($columns)
                ->where('stoppage_id', $stoppage_id)
                ->with([
                    'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                    'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                    'stoppage:id,name'
                ]);
            }else if(!empty($route_id)){
                $data = StudentTransport::select($columns)
                ->where('route_id', $route_id)
                ->with([
                    'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                    'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                    'stoppage:id,name'
                ]);
            }else if(!empty($student_id)){
                $stuPrimaryID = StudentInfo::where('student_id_no',$student_id)->first()->id;
                $data = StudentTransport::select($columns)
                ->where('student_id', $stuPrimaryID)
                ->with([
                    'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                    'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                    'stoppage:id,name'
                ]);
            }
            // Fetch metadata for the table top
            $route = $data->first()?->transportRoute; // Get the first record's transportRoute
            $route_name = $route->route_name ?? 'N/A';
            $vehicle_number = $route->vehicle->vehicle_number ?? 'N/A';
            $driver_name = $route->employee->name ?? 'N/A';
            $driver_contact = $route->employee->mobile_number ?? 'N/A';
            // Return the DataTable
            return DataTables::of($data)
                ->addColumn('student_name', function ($data) {
                    return $data->studentInfo->name ?? 'N/A'; // Assuming studentInfo relation exists
                })
                ->addColumn('student_id', function ($data) {
                    return $data->studentInfo->student_id_no ?? 'N/A'; // Assuming studentInfo relation exists
                })
                ->addColumn('student_class', function ($data) {
                    $studentClasse = $data->studentInfo->studentClass->class_name ?? 'N/A';
                    $section = $data->studentInfo->section->section_name ?? 'N/A';
                    return '<span class="text-capitalize">'.e($studentClasse).' ('.e($section).')</span>';
                })
                ->addColumn('guardian_name', function ($data) {
                    return $data->studentInfo->guardian_name ?? 'N/A' ; // Assuming studentInfo relation exists
                })
                ->addColumn('guardian_contact', function ($data) {
                    return $data->studentInfo->guardian_mobile ?? 'N/A'; // Assuming studentInfo relation exists
                })
                ->addColumn('stoppage_id', function ($data) {
                    return $data->stoppage->name ?? 'N/A'; // Assuming stoppage relation exists
                })
                ->addColumn('monthly_cost', function ($data) {
                    // Check if hostelRoom and roomType are loaded and exist
                    return $data->monthly_cost ?? 'N/A'; // Safely access the roomType name
                })
                ->rawColumns(['student_class'])
                ->with([
                    'vehicle_number' => $vehicle_number,
                    'route_name' => $route_name,
                    'driver_name' => $driver_name,
                    'driver_contact' => $driver_contact,
                ])
                ->make(true);
        }catch (\Exception $e) {
            \Log::error('Error in Hostel report: ' . $e->getMessage());
            return response()->json(['error' => 'An error occurred. Please try again later.'], 500);
        }
    }

    public function routeWiseStudentPDF(Request $request){
        // $request->validate([
        //     'route_id' => 'required',
        // ]); 
        // // route_id
        // $route_id = $request->input('route_id');
        // // Fetch the selected columns or set defaults
        // $selectedColumns = $request->input('selected_columns', []);
        // if (empty($selectedColumns)) {
        //     $selectedColumns = ['student_id','route_id','stoppage_id','monthly_cost'];
        // }
        // // Always include necessary columns
        // $requiredColumns = ['student_id','route_id'];
        // $selectColumns = array_unique(array_merge($selectedColumns, $requiredColumns));
        // $columns = array_diff($selectColumns,['student_name','student_class','guardian_name','guardian_contact']);
        // // Build the query
        // $data = StudentTransport::select($columns)
        // ->where('route_id', $route_id)
        // ->with([
        //     'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
        //     'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
        //     'stoppage:id,name'
        // ]);

        $route_id = $request->input('route_id');
        $stoppage_id = $request->input('stoppage_id');
        $student_id = $request->input('student_id');
        // Fetch the selected columns or set defaults
        $selectedColumns = $request->input('selected_columns', []);
        if (empty($selectedColumns)) {
            $selectedColumns = ['student_id','route_id','stoppage_id','monthly_cost'];
        }

        // Always include necessary columns
        $requiredColumns = ['student_id','route_id'];
        $selectColumns = array_unique(array_merge($selectedColumns, $requiredColumns));
        $columns = array_diff($selectColumns,['student_name','student_class','guardian_name','guardian_contact']);

        // Build the query
        if(!empty($stoppage_id)){
            $data = StudentTransport::select($columns)
            ->where('stoppage_id', $stoppage_id)
            ->with([
                'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                'stoppage:id,name'
            ]);
        }else if(!empty($route_id)){
            $data = StudentTransport::select($columns)
            ->where('route_id', $route_id)
            ->with([
                'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                'stoppage:id,name'
            ]);
        }else if(!empty($student_id)){
            $stuPrimaryID = StudentInfo::where('student_id_no',$student_id)->first()->id;
            $data = StudentTransport::select($columns)
            ->where('student_id', $stuPrimaryID)
            ->with([
                'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                'stoppage:id,name'
            ]);
        }
        

        $all_data = $data->get();
        // Fetch metadata for the table top
        $route = $data->first()?->transportRoute; // Get the first record's transportRoute
        $route_name = $route->route_name ?? 'N/A';
        $vehicle_number = $route->vehicle->vehicle_number ?? 'N/A';
        $driver_name = $route->employee->name ?? 'N/A';
        $driver_contact = $route->employee->mobile_number ?? 'N/A';

        $pdf = Pdf::loadView('report.transport.route-wise-transport-pdf', ['transports'=>$all_data,'columns'=>$selectedColumns,'route_name'=>$route_name,'vehicle_number'=>$vehicle_number,'driver_name'=>$driver_name,'driver_contact'=>$driver_contact,'report_name'=>'Transport Report']);
        return response()->streamDownload(function () use ($pdf) {
            echo $pdf->stream();
        }, 'users.pdf', [
            'Content-Type' => 'application/pdf',
        ]);
    }

    public function routeWiseStudentExcel(Request $request){ 
        // $request->validate([
        //     'route_id' => 'required',
        // ]); 
        // // route_id
        // $route_id = $request->input('route_id');
        // // Fetch the selected columns or set defaults
        // $selectedColumns = $request->input('selected_columns', []);
        // if (empty($selectedColumns)) {
        //     $selectedColumns = ['student_id','route_id','stoppage_id','monthly_cost'];
        // }
        // // Always include necessary columns
        // $requiredColumns = ['student_id','route_id'];
        // $selectColumns = array_unique(array_merge($selectedColumns, $requiredColumns));
        // $columns = array_diff($selectColumns,['student_name','student_class','guardian_name','guardian_contact']);
        // // Build the query
        // $query = StudentTransport::select($columns)
        // ->where('route_id', $route_id)
        // ->with([
        //     'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
        //     'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
        //     'stoppage:id,name'
        // ]);

        $route_id = $request->input('route_id');
        $stoppage_id = $request->input('stoppage_id');
        $student_id = $request->input('student_id');
        // Fetch the selected columns or set defaults
        $selectedColumns = $request->input('selected_columns', []);
        if (empty($selectedColumns)) {
            $selectedColumns = ['student_id','route_id','stoppage_id','monthly_cost'];
        }

        // Always include necessary columns
        $requiredColumns = ['student_id','route_id'];
        $selectColumns = array_unique(array_merge($selectedColumns, $requiredColumns));
        $columns = array_diff($selectColumns,['student_name','student_class','guardian_name','guardian_contact']);

        // Build the query
        if(!empty($stoppage_id)){
            $query = StudentTransport::select($columns)
            ->where('stoppage_id', $stoppage_id)
            ->with([
                'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                'stoppage:id,name'
            ]);
        }else if(!empty($route_id)){
            $query = StudentTransport::select($columns)
            ->where('route_id', $route_id)
            ->with([
                'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                'stoppage:id,name'
            ]);
        }else if(!empty($student_id)){
            $stuPrimaryID = StudentInfo::where('student_id_no',$student_id)->first()->id;
            $query = StudentTransport::select($columns)
            ->where('student_id', $stuPrimaryID)
            ->with([
                'studentInfo:id,student_id_no,name,student_class_id,section_id,guardian_name,guardian_mobile',
                'transportRoute:id,route_name,vehicle_id,driver_id', // Specific columns from transportRoute
                'stoppage:id,name'
            ]);
        }

        $data = $query->get();
        // Fetch metadata for the table top
        $route = $query->first()?->transportRoute; // Get the first record's transportRoute
        $route_name = $route->route_name ?? 'N/A';
        $vehicle_number = $route->vehicle->vehicle_number ?? 'N/A';
        $driver_name = $route->employee->name ?? 'N/A';
        $driver_contact = $route->employee->mobile_number ?? 'N/A';

        $data['route_name'] = $route_name;
        $data['vehicle_number'] = $vehicle_number;
        $data['driver_name'] = $driver_name;
        $data['driver_contact'] = $driver_contact;
        $data['institute_name'] = $this->institute_name;
        $data['report_name'] = 'Transport Report';
        return Excel::download(new TranspoerExport($data,$selectedColumns), 'transport-report.xlsx');
    }

    public function classWiseStudent(){
        $route_id = '';
        $transport_routes = TransportRoute::pluck('route_name','id');
        return view('report.transport.class-wise-student-report', compact('route_id','transport_routes'));
    }
    
}
