<?php

namespace App\Http\Controllers\Result;

use App\Http\Controllers\Controller;
use App\Models\Result\MarkHeadAssign;
use App\Models\Student\StudentInfo;
use App\Services\Sms\SmsService;

class ExamController extends Controller
{
    private $smsService;

    public function __construct(SmsService $smsService)
    {
        $this->smsService = $smsService;
    }

    public function getStudentsWithExamRecords($exam_id, $academic_year)
    {
        return StudentInfo::whereHas('examRecords', function ($query) use ($exam_id, $academic_year) {
            $query->where('exam_id', $exam_id)
                ->where('year', $academic_year);
        })
            ->with(['examRecords' => function ($query) use ($exam_id, $academic_year) {
                $query->where('exam_id', $exam_id)
                    ->where('year', $academic_year)
                    ->orderBy('subject_id');
            }])
            ->orderBy('student_class_id', 'ASC')
            ->orderBy('class_roll', 'ASC')
            ->get();
    }

    public function calculateStudentResults($student, $exam_id, $academic_year, $grades, $markHeads, $academicYears)
    {
        static $prev_student_class_id = '';
        static $subject_head_marks = [];

        $results = [];
        $grand_total = 0;
        $grand_total_obtain = 0;
        $fail_count = 0;

        $student_class_id = $student->student_class_id ?? "";

        if ($prev_student_class_id != $student_class_id) {
            $assignedMarksHead = MarkHeadAssign::where('exam_id', $exam_id)->where('student_class_id', $student_class_id)->pluck('head_marks', 'subject_id');
            $subject_head_marks = $assignedMarksHead;
        }

        foreach ($student->examRecords as $records) {
            $total_marks_obtain = 0;
            $full_marks = 0;

            $head_wise_marks_record = json_decode($records->head_wise_marks, true);
            $head_marks_data = $subject_head_marks[$records->subject->id] ?? null;
            $head_marks_array = json_decode($head_marks_data, true);

            foreach ($markHeads as $head) {
                if (isset($head_marks_array[$head->id])) {
                    $full_marks += $head_marks_array[$head->id];
                    $total_marks_obtain += $head_wise_marks_record[$head->id] ?? 0;
                }
            }

            $grand_total_obtain += $total_marks_obtain;
            $grand_total += $full_marks;

            $total_percentage = $total_marks_obtain > 0 ? round(($total_marks_obtain * 100) / $full_marks) : 0;
            $grade_name = $this->getGradeName($grades, $total_percentage);
            if ($grade_name == 'F') {
                $fail_count++;
            }
        }

        $grand_total_percentage = $grand_total_obtain > 0 ? round(($grand_total_obtain * 100) / $grand_total) : 0;
        $grade_name = $this->getGradeName($grades, $grand_total_percentage);
        $gpa = $this->getGpa($grades, $grand_total_percentage);

        if ($fail_count > 0) {
            $grade_name = 'F';
            $gpa = '0.00';
        }

        $prev_student_class_id = $student_class_id;

        return compact('grade_name', 'gpa', 'grand_total_obtain', 'grand_total');
    }

    public function getGradeName($grades, $percentage)
    {
        foreach ($grades as $grade) {
            if ($grade->mark_from <= $percentage && $grade->mark_to >= $percentage) {
                return $grade->name;
            }
        }
        return '';
    }

    public function getGpa($grades, $percentage)
    {
        foreach ($grades as $grade) {
            if ($grade->mark_from <= $percentage && $grade->mark_to >= $percentage) {
                return $grade->gpa;
            }
        }
        return '';
    }
}