<?php

namespace App\Http\Controllers\Result;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Academic\Building;
use App\Models\Result\ExamRoutine;
use App\Http\Controllers\Controller;
use App\Models\Academic\StudentClass;
use App\Models\Academic\SubjectsAssign;

class ExamRoutineController extends Controller
{
    public function index()
    {
        $studentClasses = StudentClass::with('classTimePeriods')->get();
        return view('pages.academic.class_time_period.index', compact('studentClasses'));
    }

    public function create()
    {
        $classes = StudentClass::all();
        $student_class_id = '';
        return view('pages.academic.class_time_period.create',compact('classes', 'student_class_id'));
    }

    public function search(Request $request){

        $student_class_id = $request->student_class_id;

        $checkPreviousRutine = ExamRoutine::with('subject')->where('student_class_id', '=', $student_class_id)->get();

        if(!$checkPreviousRutine->isEmpty()){
            $subjectsAssigns = $checkPreviousRutine;
        }else{
            $subjectsAssigns = SubjectsAssign::with('subject')->where('subjects_assigns.student_class_id',$student_class_id)->get();
        }

        $teachers = User::where('user_type','teacher')->pluck('name','id');
        $buildings = Building::where('branch_id',auth()->user()->branch_id)->pluck('building_name','id');
        $classes = StudentClass::all();

        return view('pages.academic.class_time_period.create',compact('subjectsAssigns','teachers','buildings','classes', 'student_class_id'));
    }

    public function store(Request $request)
    {
        // Retrieve the form fields from the request
        $subjectIds = $request->input('subject_id');
        $teacherIds = $request->input('teacher_id');
        $startTimes = $request->input('start_time');
        $endTimes = $request->input('end_time');
        $roomNos = $request->input('room_no');
        $studentClassId = $request->input('student_class_id');

        // Iterate over the form fields and create or update records
        foreach ($subjectIds as $index => $subjectId) {
            ExamRoutine::updateOrCreate(
                [
                    'student_class_id' => $studentClassId,
                    'subject_id' => $subjectId,
                ],
                [
                    'branch_id' => auth()->user()->branch_id,
                    'student_class_id' => $studentClassId,
                    'subject_id' => $subjectId,
                    'teacher_id' => $teacherIds[$index],
                    'start_time' => $startTimes[$index],
                    'end_time' => $endTimes[$index],
                    'class_room_id' => $roomNos[$index],
                ]
            );
        }

        $subjectsAssigns = ExamRoutine::with('subject')->where('student_class_id', '=', $studentClassId)->get();

        return redirect()->route('class_time_periods.index')->with('success', 'Class time period created successfully.');
    }

    public function show($id)
    {
        $subjectsAssigns = ExamRoutine::with('subject')->where('student_class_id', '=', $id)->get();
        $teachers = User::where('user_type','teacher')->pluck('name','id')->toArray();
        return view('pages.academic.class_time_period.show', compact('subjectsAssigns', 'teachers'));
    }

    public function edit($student_class_id)
    {

        $checkPreviousRutine = ExamRoutine::with('subject')->where('student_class_id', '=', $student_class_id)->get();

        if(!$checkPreviousRutine->isEmpty()){
            $subjectsAssigns = $checkPreviousRutine;
        }else{
            $subjectsAssigns = SubjectsAssign::with('subject')->where('subjects_assigns.student_class_id',$student_class_id)->get();
        }

        $teachers = User::where('user_type','teacher')->pluck('name','id');

        $classes = StudentClass::all();

        return view('pages.academic.class_time_period.edit', compact('subjectsAssigns', 'classes', 'teachers', 'student_class_id'));
    }

    public function update(Request $request, $id)
    {

        $classTimePeriod = ExamRoutine::findOrFail($id);
        $classTimePeriod->update($request->all());

        return redirect()->route('class_time_periods.index')->with('success', 'Class time period updated successfully.');
    }

    public function destroy($id)
    {
        // Delete the class routine
        ExamRoutine::where('student_class_id', $id)->delete();

        return redirect()->route('class_time_periods.index')->with('success', 'Class time period deleted successfully.');
    }
}
