<?php

namespace App\Http\Controllers\Result;

use App\Models\Result\Exam;
use Illuminate\Http\Request;
use App\Models\Academic\Shift;
use App\Services\StudentInfoService;
use App\Http\Controllers\Controller;

class SeatPlanController extends Controller
{
    protected $studentInfoService;

    public function __construct(StudentInfoService $studentInfoService)
    {
        $this->studentInfoService = $studentInfoService;
    }

    public function index(Request $request)
    {
        $this->authorize('exam-result.seat-plan.view');
        
        $data = $this->studentInfoService->getRelatedData();
        $data['exam_id'] = '';
        $data['exams'] = Exam::with('academic_year')->orderBy('id','desc')->get();
        $data['shifts'] = Shift::select('id', 'shift_name')->get();
        $data['academic_year'] = '';
        if (!empty($request->query())) {
            $data['students'] = $this->studentInfoService->getStudents($request->query());
        } else {
            $data['students'] = collect();
        }
        // dd($data);
        return view('pages.result.seat-plan.index', $data);
    }

    public function filter(Request $request){
        $this->authorize('exam-result.seat-plan.filter');

        // dd($request->all());
        $data = $this->studentInfoService->getRelatedData();
        $data['exam_id'] = $request->exam ?? 0;
        $data['exams'] = Exam::with('academic_year')->orderBy('id','desc')->get();
        $data['shifts'] = Shift::select('id', 'shift_name')->get();
        $data['selected_exam'] =  Exam::where('id',$request->exam)->first();
        $data['academic_year'] = optional(optional(Exam::find($request->exam))->academic_year)->year;

        if (!empty($request->all())) {
            $data['students'] = $this->studentInfoService->getStudents($request->all());
        } else {
            $data['students'] = collect();
        }
        // dd($data);
        return view('pages.result.seat-plan.index')->with($data);
    }
}
