<?php

namespace App\Http\Controllers\Result;

use App\Http\Controllers\Controller;
use App\Services\Student\StudentPromotionService;
use Illuminate\Http\Request;

class StudentPromotionController extends Controller
{
    protected $promotionService;

    public function __construct(StudentPromotionService $promotionService)
    {
        $this->promotionService = $promotionService;
    }

    public function create(Request $request)
    {
        $data = $this->promotionService->getRelatedData();
        // dd($data );
        if(!empty($request->from_academic_year) && !empty($request->to_academic_year) && ($request->from_academic_year == $request->to_academic_year)){
            return view('pages.students.promotion.create', $data)->with('error', 'Academic year can not be same');
        }
        if($request->from_class && $request->to_class ){
            $data['students'] = $this->promotionService->getStudentsByClass($request);
        }
        // dd($request->all(),$data);
        return view('pages.students.promotion.create', $data);
    }

    public function storePromotion(Request $request)
    {
        $this->promotionService->promoteStudents($request);
        return redirect()->route('student.promotion.create')
            ->with('success', 'Students promoted successfully!');
    }


    public function updateMeritPositions(Request $request)
    {
        $this->promotionService->updateMeritPositions($request);
    }

    public function graduation(Request $request)
    {
        $data = $this->promotionService->getRelatedData();
        if($request->from_class){
            $data['students'] = $this->promotionService->getStudentsByClass($request);
        }
        // dd($data);
        return view('pages.students.graduation.create', $data);
    }


    public function graduationStore(Request $request)
    {
        $result = $this->promotionService->graduationStore($request);
        if($result){
            return redirect()->route('student.graduation.create')
                ->with('success', 'Students graduated successfully!');
        }else{
            return redirect()->route('student.graduation.create')
                ->with('error', 'Something went wrong!');
        }
    }
}
