<?php

namespace App\Http\Controllers\RolePermission;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Str;

class RoleController extends Controller
{
    public function index()
    {
        $roles = Role::all();
        return view('role-permission.role.index', compact('roles'));
    }

    public function create()
    {
        return view('role-permission.role.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string', 'unique:roles,name']
        ]);

        Role::create([
            'name' => Str::slug(strtolower($request->name)),
            'display_name' => $request->name,
        ]);

        return redirect('roles')->with('success', 'Role Created Successfully.');
    }

    public function show() {}

    public function edit($id)
    {
        $role = Role::findById($id);
        return view('role-permission.role.edit', compact('role'));
    }

    public function update(Request $request, Role $role)
    {
        $request->validate([
            'name' => ['required', 'string', 'unique:roles,name,' . $role->id]
        ]);

        $role->update([
            'name' => Str::slug(strtolower($request->name)),
            'display_name' => $request->name,
        ]);

        return redirect('roles')->with('success', 'Role Updated Successfully.');
    }

    public function destroy(Role $role)
    {
        $role->delete();
        return redirect('roles')->with('warning', 'Role Deleted Successfully.');
    }

    public function assignPermission($role_id)
    {
        $role = Role::findOrFail($role_id);
        $assignPermissions = DB::table('role_has_permissions')
            ->where('role_id', $role_id)
            ->pluck('permission_id', 'permission_id')
            ->all();

        $permissions = Permission::orderBy('orders', 'asc')->get();

        $hierarchicalPermissions = $permissions->groupBy(function ($item) {
            return explode('.', $item->name)[0]; // Main category
        })->map(function ($items, $categoryName) {
            $groupedItems = $items->groupBy(function ($item) use ($categoryName) {
                $parts = explode('.', $item->name);
                return isset($parts[1]) ? $parts[1] : $categoryName; // Subcategory
            });

            // Separate out permissions without children
            $standalone = $groupedItems->filter(function ($subGroup, $subCategoryName) {
                return $subCategoryName === $subGroup->first()->name;
            });
            // $groupedItems = $groupedItems->filter(function ($subGroup, $subCategoryName) {
            //     return $subCategoryName !== $subGroup->first()->name;
            // });

            return ['grouped' => $groupedItems, 'standalone' => $standalone->flatten()];
        });
        // dd($assignPermissions, $hierarchicalPermissions);

        return view('role-permission.assign-pernission.create', compact('role', 'assignPermissions', 'hierarchicalPermissions'));
    }


    public function storeAssignPermission(Request $request, $role_id)
    {
        $request->validate([
            'permission' => 'required',
        ]);
//         dd($request);
        $role = Role::findOrFail($role_id);
        $role->syncPermissions($request->permission);
        return redirect()->back()->with('success', 'Permission Assigned Successfully.');
    }


    public function assignRole($userId)
    {
        $roles = Role::all();
        $user = User::findOrFail($userId);
        return view('role-permission.users.assign-role', compact('roles', 'user'));
    }

    public function assignRoleStore(Request $request)
    {
        $user = User::findOrFail($request->user_id);
        $user->syncRoles($request->roles);
        return redirect()->route('permissions.users.list')->with('success', 'Role Assigned Successfully.');
    }
}
