<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Services\SettingService;
use Illuminate\Support\Facades\Cache;

class SettingController extends Controller
{

    protected $settingService;

    public function __construct(SettingService $settingService)
    {
        $this->settingService = $settingService;
    }

    public function index()
    {
        $data = $this->settingService->getRelatedData();
        $data['title'] = 'Settings';
        return view("setting.index", $data);
    }


    public function settingUpdate(Request $request)
    {
        // Cache::forget("setting_{$key}");
        // return Cache::remember("setting_{$key}", 43200, function () use ($key) {
        //     $setting = Setting::where('key', $key)->first();
        //     if (empty($setting)) {
        //         $setting = (object)[
        //             'key' => $key,
        //             'value' => null, 
        //         ];
        //     }
        //     Cache::put("setting_{$key}", $setting, 43200);
        //     return $setting;
        // });


        $this->settingService->updateSettings($request);
        return redirect()->back()->with('success', 'Setting Updated successfully.');
    }

    public function accounting()
    {
        $data = $this->settingService->getRelatedData();
        $data['title'] = 'Accounting';
        return view("setting.accounting", $data);
    }
}
