<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Jobs\SendSmsJob;
use App\Constants\Status;
use App\Models\SmsRecord;
use Illuminate\Http\Request;
use App\Models\Academic\Group;
use App\Models\Academic\Shift;
use App\Models\Academic\Branch;
use App\Models\Academic\Section;
use App\Services\Sms\SmsService;
use Illuminate\Support\Facades\DB;
use App\Models\Student\StudentInfo;
use App\Models\Academic\StudentClass;
use App\Models\HrPayroll\HrDepartment;

class SmsController extends Controller
{
    public function generalSmsList()
    {
        $student_class_id = '';
        $section_id = '';
        $group_id = '';
        $shift_id = '';
        $all_guardian_number = '';
        $students = [];
        $studentClasses = StudentClass::pluck('class_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name', 'id');
        $branches = Branch::pluck('branch_name', 'id');
        $employee_type = "";

        $generalSmsList = SmsRecord::where('type', 'general')->get();
        return view('pages.sms.general_sms.index', compact('students', 'studentClasses', 'groups', 'shifts', 'sections', 'branches', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'all_guardian_number', 'employee_type', 'generalSmsList'));
    }

    public function generalSmsCreate()
    {
        return view('pages.sms.general_sms.create');
    }

    public function generalSmsSend(Request $request)
    {
        $validatedData = $request->validate([
            'mobile_number' => 'required',
            'sms_body' => 'required',
        ]);

        $mobileNumbers = array_map('trim', explode(',', $validatedData['mobile_number']));

        $smsBody = $validatedData['sms_body'];

        $successCount = 0;
        $failCount = 0;
        $invalidNumbers = [];
        //chunking the mobile numbers
        $chunkedNumbers = array_chunk($mobileNumbers, 100);
        foreach ($chunkedNumbers as $chunk) {
            foreach ($chunk as $number) {
                if (isValidBangladeshiNumber($number)) {
                    SendSmsJob::dispatch($number, $smsBody, 'general', ['branch_id' => auth()->user()->branch_id]);
                    $successCount++;
                } else {
                    $invalidNumbers[] = $number;
                    $failCount++;
                }
            }
        }
        return redirect()->route('general-sms.list')->with(
            'success', "$successCount SMS successfully send. " . " <span style='background: yellow; color: red;'>$failCount SMS failed to send. " . implode(',', $invalidNumbers) . " invalid number(s) found.</span>",
        );
    }

    public function DepartmentWiseSms()
    {
        $studentClasses = StudentClass::select('id', 'class_name')->get();
        $student_class_id = '';
        $students = [];
        $total_students = 0;
        return view('pages.sms.branch.create', compact('studentClasses', 'student_class_id', 'students', 'total_students'));
    }

    public function DepartmentWiseStudent(Request $request)
    {
        $student_class_id = $request->student_class_id;

        if ($student_class_id === 'all') {
            $student_class_ids = StudentClass::pluck('id')->toArray();
        } else {
            $student_class_ids = [$student_class_id];
        }
        $students = StudentInfo::query();
        $students->whereIn('student_class_id', $student_class_ids)->where('status', Status::ACTIVE);

        $all_mobile_no = $students->pluck('mobile_no')->implode(',');
        $students = $students->orderBy('class_roll', 'ASC')->get();
        $total_students = $students->count() ?? 0;

        $studentClasses = StudentClass::select('id', 'class_name')->get();
        return view('pages.sms.branch.create', compact('students', 'all_mobile_no', 'studentClasses', 'student_class_id', 'total_students'));
    }

    public function DepartmentWiseStudentSend(Request $request)
    {
        $validatedData = $request->validate([
            'mobile_number' => 'required',
            'sms_body' => 'required',
        ]);

        $first_number = explode(',', $request->mobile_number[0]);

        if (count($first_number) > 1) {
            $mobileNumbers = $first_number;
        } else {
            $mobileNumbers = $request->mobile_number;
        }

        $smsBody = $validatedData['sms_body'];

        $successCount = 0;
        $failCount = 0;
        $invalidNumbers = [];


        //chunking the mobile numbers
        $chunkedNumbers = array_chunk($mobileNumbers, 100);
        foreach ($chunkedNumbers as $chunk) {
            foreach ($chunk as $number) {
                if (isValidBangladeshiNumber($number)) {
                    SendSmsJob::dispatch($number, $smsBody, 'student', ['branch_id' => auth()->user()->branch_id]);
                    $successCount++;
                } else {
                    $invalidNumbers[] = $number;
                    $failCount++;
                }
            }
        }
        return redirect()->route('student-sms.department-wise-sms')->with(
            'success', "$successCount SMS successfully send. " . " <span style='background: yellow; color: red;'>$failCount SMS failed to send. " . implode(',', $invalidNumbers) . " invalid number(s) found.</span>",
        );
    }


    public function studentSmsList()
    {
        $studentSmsList = SmsRecord::where('type', 'student')->get();
        return view('pages.sms.student_sms.index', compact('studentSmsList'));
    }

    public function studentSmsCreate()
    {
        $student_class_id = '';
        $section_id = '';
        $group_id = '';
        $shift_id = '';
        $all_guardian_number = '';
        $students = [];
        $studentClasses = StudentClass::pluck('class_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name', 'id');
        $branches = Branch::pluck('branch_name', 'id');
        return view('pages.sms.student_sms.create', compact('students', 'studentClasses', 'groups', 'shifts', 'sections', 'branches', 'student_class_id', 'section_id', 'group_id', 'shift_id', 'all_guardian_number'));
    }

    public function searchStudentInfo(Request $request)
    {

        $student_class_id = $request->student_class_id;
        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $shift_id = $request->shift_id;

        $students = StudentInfo::query();

        if ($request->has('student_class_id')) {
            $students->where('student_class_id', $request->input('student_class_id'));
        }

        if (!empty($section_id)) {
            $students->where('section_id', $request->input('section_id'));
        }

        if (!empty($group_id)) {
            $students->where('group_id', $request->input('group_id'));
        }

        if (!empty($shift_id)) {
            $students->where('shift_id', $request->input('shift_id'));
        }

        $students->where('status', '!=', Status::GRADUATED);

        $all_mobile_no = $students->pluck('mobile_no')->implode(',');
        $students = $students->orderBy('class_roll', 'ASC')->get();

        $studentClasses = StudentClass::pluck('class_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name', 'id');
        $branches = Branch::pluck('branch_name', 'id');

        $total_students = $students->count() ?? 0;

        return view('pages.sms.student_sms.create', compact('students', 'total_students', 'all_mobile_no', 'studentClasses', 'groups', 'shifts', 'sections', 'branches', 'student_class_id', 'section_id', 'group_id', 'shift_id'));
    }

    public function studentSmsSend(Request $request, SmsService $smsService)
    {
        $validatedData = $request->validate([
            'mobile_number' => 'required',
            'sms_body' => 'required',
        ]);

        $first_number = explode(',', $request->mobile_number[0]);

        if (count($first_number) > 1) {

            $mobileNumbers = $first_number;
        } else {
            $mobileNumbers = $request->mobile_number;
        }

        $smsBody = $validatedData['sms_body'];

        $successCount = 0;
        $failCount = 0;
        $invalidNumbers = [];

        //chunking the mobile numbers
        $chunkedNumbers = array_chunk($mobileNumbers, 100);
        foreach ($chunkedNumbers as $chunk) {
            foreach ($chunk as $number) {
                if (isValidBangladeshiNumber($number)) {
                    SendSmsJob::dispatch($number, $smsBody, 'student', ['branch_id' => auth()->user()->branch_id]);
                    $successCount++;
                } else {
                    $invalidNumbers[] = $number;
                    $failCount++;
                }
            }
        }


        return redirect()->route('student-sms.list')->with(
            'success', "$successCount SMS successfully send. " . " <span style='background: yellow; color: red;'>$failCount SMS failed to send. " . implode(',', $invalidNumbers) . " invalid number(s) found.</span>",
        );
    }


    public function employeeSmsList()
    {
        $employeeSmsList = SmsRecord::where('type', 'employee')->get();

        return view('pages.sms.employee_sms.index', compact('employeeSmsList'));
    }

    public function employeeSmsCreate()
    {
        $departments = HrDepartment::pluck('name', 'id');
        $branches = Branch::pluck('branch_name', 'id');
        $employees = [];
        $employee_type = "";
        return view('pages.sms.employee_sms.create', compact('employees', 'departments', 'branches', 'employee_type'));
    }

    public function searchEmployeeInfo(Request $request)
    {

        $employee_type = $request->employee_type;

        $employees = User::query();

        if ($employee_type == 'all') {
            $employees->whereNot('user_type', 'student')->whereNot('user_type', 'super-admin')->whereNot('user_type', 'admin');
        } else {
            $employees->where('user_type', $request->employee_type);
        }

        $all_employee_number = $employees->pluck('phone_number')->implode(',');
        $employees = $employees->orderBy('id', 'ASC')->get();

        $departments = HrDepartment::pluck('name', 'id');
        $branches = Branch::pluck('branch_name', 'id');

        $total_employees = $employees->count() ?? 0;

        return view('pages.sms.employee_sms.create', compact('employees', 'total_employees', 'all_employee_number', 'departments', 'branches', 'employee_type'));
    }

    public function employeeSmsSend(Request $request, SmsService $smsService)
    {
        $validatedData = $request->validate([
            'mobile_number' => 'required',
            'sms_body' => 'required',
        ]);

        $first_number = explode(',', $request->mobile_number[0]);

        if (count($first_number) > 1) {

            $mobileNumbers = $first_number;
        } else {
            $mobileNumbers = $request->mobile_number;
        }

        $smsBody = $validatedData['sms_body'];

        $successCount = 0;
        $failCount = 0;
        $invalidNumbers = [];

        //chunking the mobile numbers
        $chunkedNumbers = array_chunk($mobileNumbers, 100);
        foreach ($chunkedNumbers as $chunk) {
            foreach ($chunk as $number) {
                if (isValidBangladeshiNumber($number)) {
                    SendSmsJob::dispatch($number, $smsBody, 'employee', ['branch_id' => auth()->user()->branch_id]);
                    $successCount++;
                } else {
                    $invalidNumbers[] = $number;
                    $failCount++;
                }
            }
        }


        return redirect()->route('employee-sms.list')->with(
            'success', "$successCount SMS successfully send. " . " <span style='background: yellow; color: red;'>$failCount SMS failed to send. " . implode(',', $invalidNumbers) . " invalid number(s) found.</span>"
        );
    }


    public function smsReports()
    {
        $search_value = '';
        $smsList = [];
        return view('pages.sms.reports.index', compact('search_value', 'smsList'));
    }

    public function searchSmsData(Request $request)
    {
        list($fromDate, $toDate) = parseDateRange($request->date_range);
        $fromDate = Carbon::parse($fromDate)->startOfDay();
        $toDate   = Carbon::parse($toDate)->endOfDay();
        $smsList = SmsRecord::with('userInfo');
        $search_value = $request->date_range;
        if (isset($fromDate) && isset($toDate)) {
            $smsList->whereBetween('send_time', [$fromDate, $toDate]);
        }
        $smsList = $smsList->get();
        return view('pages.sms.reports.index', compact('smsList', 'fromDate', 'toDate', 'search_value'));
    }

    public function dateWiseSmsReports()
    {
        $search_value = '';
        $smsList = [];
        return view('pages.sms.reports.date-wise-reports', compact('search_value', 'smsList'));
    }


    public function dateWiseSmsReportsSearch(Request $request)
    {
        $search_value = $request->date_range ?? '';
        list($fromDate, $toDate) = parseDateRange($request->date_range);

        $smsList = SmsRecord::selectRaw('status, DATE(send_time) as send_date, COUNT(*) as total_sms, SUM(number_of_sms) as total_segments, SUM(sms_cost) as total_cost')
            ->whereNotNull('send_time')
            ->whereBetween('send_time', [$fromDate . ' 00:00:00', $toDate . ' 23:59:59'])
            ->groupBy(DB::raw('DATE(send_time)'))
            ->orderByDesc('send_date')
            ->get();
        return view('pages.sms.reports.date-wise-reports', compact('smsList', 'fromDate', 'toDate', 'search_value'));
    }

}
