<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use App\Models\HrPayroll\Leave;
use App\Models\Holiday\Holiday;
use App\Services\Student\StudentDashboardService;
use Illuminate\Http\Request;
class StudentDashBoardController extends Controller
{
    private $studentDashboardService;

    public function __construct(StudentDashboardService $studentDashboardService)
    {
        $this->studentDashboardService = $studentDashboardService;
    }

    public function index()
    {
        $data['studentInfo'] = $this->studentDashboardService->getStudentInfo();
        $data['feeDetails'] = $this->studentDashboardService->getFeesSummary();
        $data['myFriends'] = $this->studentDashboardService->getMyFriends();
        $data['myCurrentAttendance'] = $this->studentDashboardService->getMyCurrentAttendance();
        $data['myApprovedLeaves'] = $this->studentDashboardService->getMyApprovedLeaves();
        $data['holidays'] = Holiday::all(['id', 'title', 'start_date', 'end_date']);
        // dd($data);
        return view('students-dashboard.layout.dashboard', $data);
    }


    public function profile()
    {
        $data['studentInfo'] = $this->studentDashboardService->getStudentInfo();
        return view('students-dashboard.pages.profile', $data);
    }

    public function myFriends()
    {
        $data['myFriends'] = $this->studentDashboardService->getMyFriends();
        return view('students-dashboard.pages.my-friends', $data);
    }

    public function classTimeTable()
    {
        $data['classRoutine'] = $this->studentDashboardService->getClassRoutine();
        return view('students-dashboard.pages.class-routine', $data);
    }

    public function mySubjects()
    {
        $data['mySubjects'] = $this->studentDashboardService->getMySubjects();
        // dd($data);
        return view('students-dashboard.pages.my-subjects', $data);
    }

    public function myFees()
    {
        $data['myFees'] = $this->studentDashboardService->getMyFees();
        return view('students-dashboard.pages.my-fees', $data);
    }

    public function dueFees()
    {
        $data['dueFees'] = $this->studentDashboardService->getDueFees();
        return view('students-dashboard.pages.due-fees', $data);
    }


    public function myAttendance()
    {
        $data['attendances'] = $this->studentDashboardService->getMyAttendanceHistory();
        return view('students-dashboard.pages.my-attendance', $data);
    }

    public function myMarkSheet(Request $request)
    {
        $data = $this->studentDashboardService->getMyMarkSheet($request);
        return view('students-dashboard.pages.my-mark-sheet', $data);
    }

    public function viewOthersMarkSheet(Request $request)
    {
        $data = $this->studentDashboardService->getOthersMarkSheet($request);
        
        return view('students-dashboard.pages.others-mark-sheet', $data);
    }

    public function applyLeave()
    {
        $data['leaveTypes'] = $this->studentDashboardService->getLeaveTypes();
        return view('students-dashboard.pages.apply-leave', $data);
    }

    public function storeApplyLeave(Request $request)
    {
        $this->studentDashboardService->storeApplyLeave($request);
        return redirect()->route('student.leave-history')->with('success', 'Leave applied successfully');
    }

    public function editApplyLeave(Leave $leave)
    {
        $data['leaveTypes'] = $this->studentDashboardService->getLeaveTypes();
        $data['leave'] = $leave->load('leaveType');
        return view('students-dashboard.pages.apply-leave-edit', $data);
    }

    public function updateApplyLeave(Request $request, Leave $leave)
    {
        $this->studentDashboardService->updateApplyLeave($request, $leave);
        return redirect()->route('student.leave-history')->with('success', 'Leave updated successfully');
    }

    public function leaveHistory()
    {
        $data['leaveHistory'] = $this->studentDashboardService->getLeaveHistory();
        return view('students-dashboard.pages.leave-history', $data);
    }

    public function deleteApplyLeave(Leave $leave)
    {
        $this->studentDashboardService->deleteApplyLeave($leave);
        return redirect()->route('student.leave-history')->with('success', 'Leave deleted successfully');
    }
}
