<?php

namespace App\Http\Controllers\Student;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Homework\Homework;
use App\Services\FileUploadService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Homework\HomeworkSubmission;
use App\Services\Student\StudentDashboardService;

class StudentHomeworkController extends Controller
{

    protected $fileUploadService;
    private $studentDashboardService;

    public function __construct(StudentDashboardService $studentDashboardService, FileUploadService $fileUploadService)
    {
        $this->studentDashboardService = $studentDashboardService;
        $this->fileUploadService = $fileUploadService;
    }

    public function homeworkHistory(){
        $today = date('Y-m-d');
        // $upcoming = Homework::whereBetween($today, ['homework_date', 'submission_date'])->get();
        // $upcoming = Homework::where('homework_date', '>=', $today)->where('submission_date', '>=', $today)->get();

        $user = User::find(Auth::id());

        $upcoming = Homework::orderBy('id', 'desc')->where('submission_date','>=',now()->toDateString())->where('student_class_id', optional($user->studentInfo)->student_class_id)->get();
        // $pasts = Homework::where('submission_date', '<=', now()->toDateString())->where('user_id', '=',Auth::id())->get();

        // dd($upcoming, optional($user->studentInfo)->id);
        return view('students-dashboard.pages.my-homework',compact('upcoming'));
    }

    public function view($id){
        $getStudentInfo = $this->studentDashboardService->getStudentInfo();
        $homework = Homework::find($id);
        $homework_id = $homework->id;
        $student_id = $getStudentInfo->user_id;
        $existingValue = HomeworkSubmission::where([['student_id',$student_id],['homework_id',$homework_id]])->first();
        return view('students-dashboard.pages.homework-view',compact('homework','existingValue'));
    }

    public function store(Request $request)
    {
        // Validate required homework ID
        $request->validate([
            'homework_id' => 'required|exists:homeworks,id', // Added exists check for robustness
            'attachment.*' => 'file|max:5120', // Optional: Validate file size (5MB/file)
        ]);

        // Fetch the homework entry
        $homework = Homework::findOrFail($request->homework_id);
        $student = $this->studentDashboardService->getStudentInfo();

        $alreadySubmitted = HomeworkSubmission::where([['student_id', $student->user_id],['homework_id', $homework->id]])->exists();



        if ($alreadySubmitted == true) {
            return redirect()->back()->with('success', 'Homework submitted successfully!');
        }


        $submission = new HomeworkSubmission();
        $submission->branch_id        = $student->branch_id;
        $submission->shift_id         = $student->shift_id;
        $submission->student_class_id = $student->student_class_id;
        $submission->section_id       = $student->section_id;
        $submission->group_id         = $student->group_id;
        $submission->student_id       = $student->user_id;
        $submission->subject_id       = $homework->subject_id;
        $submission->teacher_id       = $homework->teacher_id;
        $submission->homework_id      = $homework->id;
        $submission->answer           = $request->input('answer');

        $filePaths = [];
        if ($request->hasFile('attachment')) {
            foreach ($request->file('attachment') as $file) {
                if ($file->isValid()) {
                    $filePaths[] = $this->fileUploadService->upload($file, 'uploads/homework-student');
                }
            }
        }

        $submission->attachment = json_encode($filePaths);
        $submission->save();

        return redirect()->back()->with('success', 'Homework submitted successfully!');
   
    }

}
