<?php

namespace App\Http\Controllers\Student;

use Illuminate\Http\Request;
use App\Models\Library\Booklist;
use App\Models\Library\Bookissue;
use App\Http\Controllers\Controller;
use App\Services\Student\StudentDashboardService;

class StudentLibraryController extends Controller
{
    private $studentDashboardService;

    public function __construct(StudentDashboardService $studentDashboardService)
    {
        $this->studentDashboardService = $studentDashboardService;
    }

    public function index(){
        $user_id = $this->studentDashboardService->getStudentInfo()->user_id;
        $books = Booklist::where('quantity', '>', 0)->get();
        $bookissues = Bookissue::where('user_id',$user_id)->orderBy('created_at','asc')->get();
        return view('students-dashboard.pages.my-library', compact('books','bookissues'));
    }

    public function store(Request $request){
        $user_id = $this->studentDashboardService->getStudentInfo()->user_id;
        $request->validate([
            'book' => 'required',
            'return_date' => 'required|date|after_or_equal:today',
        ]);

        $book_id = $request->book;
        $estimate_return_date = $request->return_date;
        // $member = $request->bookmember_id;
        // $existing_book_issue = Bookissue::where([['booklist_id',$request->booklist_id],['user_id',$getStudentInfo->user_id],['bookmember_id',$request->bookmember_id]])->get();

        $existing_book_issue = Bookissue::where([['booklist_id',$book_id],['user_id',$user_id]])->get();
        if($existing_book_issue->count() == 0){
            $book = Booklist::find($book_id);
            // dd($request);
            if($book->quantity > 0){
                Bookissue::create([
                    'user_id' => $user_id,
                    // 'bookmember_id' => $request->bookmember_id,
                    'booklist_id' => $book->id,
                    'issue_date' => now(),
                    'estimate_return_date' => $estimate_return_date,
                    'status' => 'pending',
                    'created_by' => auth()->id(),
                ]);
                $book->decrement('quantity');
                return redirect()->back()->with('success', 'request successfully granted.');
            }
            return redirect()->back()->with('error', 'No copies available.');
        }else{
            return redirect()->back()->with('error', 'Book already issued');
        }
    }
}
