<?php

namespace App\Http\Controllers\Student;

use Carbon\Carbon;
use App\Models\Notice;
use App\Http\Controllers\Controller;
use App\Services\Student\StudentDashboardService;

class StudentNoticeController extends Controller
{

    private $studentDashboardService;

    public function __construct(StudentDashboardService $studentDashboardService)
    {
        $this->studentDashboardService = $studentDashboardService;
    }

    public function myNotice(){
        $getStudentInfo = $this->studentDashboardService->getStudentInfo();
        $student_class_id = $getStudentInfo->student_class_id;
        $branch_id = $getStudentInfo->branch_id;
        $today = Carbon::today();

        $all_notice = Notice::whereDate('publish_date', '<=', $today)->where('branch_id', $branch_id)
            ->where(function ($query) use ($student_class_id) {
                $query->whereDoesntHave('studentClasses') // no specific classes = show all
                    ->orWhereHas('studentClasses', function ($q) use ($student_class_id) {
                        $q->where('student_class_id', $student_class_id);
                    });
            })
            ->latest()
            ->get();
        return view('students-dashboard.pages.my-notice',compact('all_notice'));
    }

    public function myNoticeShow($id){
        $getStudentInfo = $this->studentDashboardService->getStudentInfo();
        $student_class_id = $getStudentInfo->student_class_id;
        $branch_id = $getStudentInfo->branch_id;
        $today = Carbon::today();
        $notice = Notice::findOrFail($id);
        return view('students-dashboard.pages.my-notice-show',compact('notice'));
    }


    
}
