<?php

namespace App\Http\Controllers\Student;

use App\Services\Student\StudentDashboardService;
use App\Models\Academic\StudentClass;
use App\Http\Controllers\Controller;
use App\Models\Academic\Subject;
use App\Models\Syllabus\Lesson;
use Illuminate\Http\Request;
use App\Models\Result\Exam;
use PDF;

class StudentSyllabusController extends Controller
{

    private $studentDashboardService;

    public function __construct(StudentDashboardService $studentDashboardService)
    {
        $this->studentDashboardService = $studentDashboardService;
    }

    public function index(){
        $exam_id = '';
        $subject_id = '';
        $exams = Exam::orderBy('id', 'desc')->select('id', 'exam_name', 'year')->get();
        $subjects = $this->studentDashboardService->getMySubjects();
        $getStudentInfo = $this->studentDashboardService->getStudentInfo();
        $lessons = null;
        $exam_name = null;
        $class_name = null;
        return view('students-dashboard.pages.my-syllabus', compact('lessons','exam_name','class_name','exams','subjects','exam_id','subject_id'));
    }

    public function search(Request $request){
        $exam_id = $request->exam_id;
        $subject_id = $request->subject_id;
        $exams = Exam::orderBy('id', 'desc')->select('id', 'exam_name', 'year')->get();
        $subjects = $this->studentDashboardService->getMySubjects();
        $getStudentInfo = $this->studentDashboardService->getStudentInfo();
        $student_class_id = $getStudentInfo->student_class_id;
        $exam_name = Exam::findOrFail($exam_id)->exam_name;
        $class_name = StudentClass::findOrFail($student_class_id)->class_name; 
        
        $lessons = Lesson::query();
        if(!empty($exam_id)){
            $lessons->where('exam_id', $exam_id);
        }
        if(!empty($student_class_id)){
            $lessons->where('student_class_id', $student_class_id);
        }
        if (!empty($subject_id)) {
            $lessons->where('subject_id', $subject_id);
        }
        $lessons = $lessons->with('lessonTopics')->get();
        return view('students-dashboard.pages.my-syllabus', compact('lessons','exam_name','class_name','exams','subjects','exam_id','subject_id'));
    }

    public function pdfExport(Request $request){
        $exam_id = $request->exam_id;
        $subject_id = $request->subject_id;
        $exams = Exam::orderBy('id', 'desc')->select('id', 'exam_name', 'year')->get();

        $subjects = $this->studentDashboardService->getMySubjects();
        $getStudentInfo = $this->studentDashboardService->getStudentInfo();
        $student_class_id = $getStudentInfo->student_class_id;
        $studentClasses = StudentClass::pluck('class_name','id');
        $subject = Subject::pluck('subject_name','id');
        $exam_name = Exam::findOrFail($exam_id)->exam_name;
        $class_name = StudentClass::findOrFail($student_class_id)->class_name; 

        $lessons = Lesson::query();
        if(!empty($exam_id)){
            $lessons->where('exam_id', $exam_id);
        }
        if(!empty($student_class_id)){
            $lessons->where('student_class_id', $student_class_id);
        }
        if(!empty($subject_id)) {
            $lessons->where('subject_id', $subject_id);
        }
        $lessons = $lessons->with('lessonTopics')->get();

        $pdf = Pdf::loadView('report.syllabus.pdf', ['lessons'=>$lessons,'exam_name'=>$exam_name,'class_name'=>$class_name,'report_title'=>'Syllabus Status Report']);
        return response()->streamDownload(function () use ($pdf) {
            echo $pdf->stream();
        }, 'users.pdf', [
            'Content-Type' => 'application/pdf',
        ]);
    }
}
