<?php

namespace App\Http\Controllers\Syllabus;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Academic\Subject;
use App\Models\Academic\StudentClass;
use App\Models\Syllabus\Lesson;
use App\Models\Syllabus\LessonTopic;

class LessonTopicController extends Controller
{

    public function index(){
        $student_class_id = '';
        $subject_id = '';
        $lesson_id = '';
        $studentClasses = StudentClass::pluck('class_name','id');
        $subject = Subject::pluck('subject_name','id');
        $topics = LessonTopic::groupBy('student_class_id','subject_id','lesson_id')->get();
        return view('pages.syllabus.topic.index', compact('topics','studentClasses','subject','student_class_id','subject_id','lesson_id'));
    }

    public function store(Request $request){
        $request->validate([
            'student_class_id' => 'required|integer',
            'subject_id' => 'required|integer',
            'lesson_id' => 'required|integer',
            'name.*' => 'required|string',
        ]);
        foreach ($request->name as $key => $name) {
            $topic = new LessonTopic();
            $topic->student_class_id = $request->student_class_id;
            $topic->subject_id = $request->subject_id;
            $topic->lesson_id = $request->lesson_id;
            $topic->name = $name;
            $topic->save();
        }
        return redirect()->back()->with('success', 'Topic created successfully.');
    }

    public function edit($id){
        $edit = LessonTopic::findOrFail($id);
        $student_class_id = $edit->student_class_id;
        $subject_id = $edit->subject_id;
        $lesson_id = $edit->lesson_id;
        $studentClasses = StudentClass::pluck('class_name','id');
        $subject = Subject::pluck('subject_name','id');
        $lessons = Lesson::pluck('name','id');
        $topics = LessonTopic::groupBy('student_class_id','subject_id','lesson_id')->get();
        return view('pages.syllabus.topic.edit', compact('edit','topics','studentClasses','subject','student_class_id','subject_id','lesson_id'));
    }


    public function update(Request $request, $id){
        $request->validate([
            'student_class_id' => 'required|integer',
            'subject_id' => 'required|integer',
            'lesson_id' => 'required|integer',
        ]);

        $oldData = LessonTopic::findOrFail($id);
        $oldAllData =  group_lesson_topics($oldData->student_class_id,$oldData->subject_id,$oldData->lesson_id);

        $old_lesson_ids = [];
        foreach($request->request as $key => $value){
            if(preg_match('/^name_(\d+)$/', $key, $matches)){
                $old_lesson_ids[] = $matches[1];
                LessonTopic::where('id',$matches[1])->update(['name' => $value]);
            }
        }

        $mainIds = [];
        foreach($oldAllData as $allitem){
            $mainIds[] = $allitem->id;
        }

        $deletedIds = array_diff($mainIds,$old_lesson_ids);
        foreach($deletedIds as $deletedId){
            LessonTopic::findOrFail($deletedId)->delete();
        }
        if(!empty($request->name)){
            foreach($request->name as $key => $name) {
                $topic = new LessonTopic();
                $topic->student_class_id = $request->student_class_id;
                $topic->subject_id = $request->subject_id;
                $topic->lesson_id = $request->lesson_id;
                $topic->name = $name;
                $topic->save();
            }
        }

        return redirect()->route('lesson_topic.index')->with('success', 'Topic created successfully.');
    }

    public function statusChange(Request $request){
        $topic = LessonTopic::findOrFail($request->id);
        $topic->completed_date = $request->status == 0 ? $request->completed_date : null;
        $topic->status = $request->status == 0 ? 1 : 0;
        $topic->save();
        return redirect()->back()->with('success', 'Topic status change successfully.');
      
    }

    
}
