<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Student\StudentInfo;
use App\Models\TransferCertificate;

class TransferCertificateController extends Controller
{
    
    public function index()
    {
        $certificates = TransferCertificate::with('studentInfo')->latest()->get();
        return view('pages.tc.index', compact('certificates'));
    }

    public function create($studentId)
    {
        $student = StudentInfo::findOrFail($studentId);
        return view('pages.tc.create', compact('student'));
    }

    public function store(Request $request)
    {
        $request->validate([
            // 'student_info_id' => 'required|exists:student_infos,id',
            'reason' => 'required',
        ]);

        // dd($request->all());
        $tc = new TransferCertificate();
        $tc->student_info_id = $request->student_info_id;
        $tc->reason = $request->reason;
        $tc->save();
        return redirect()->back()->with('success', 'Transfer Certificate created');
    }

    public function update(Request $request)
        {
            $request->validate([
                'reason' => 'required',
            ]);

            $tc = TransferCertificate::findOrFail($request->id);
            $tc->student_info_id = $request->student_info_id;
            $tc->reason = $request->reason;
            $tc->save();

            return redirect()->back()->with('success', 'Transfer Certificate updated successfully');
        }

    public function destroy($id)
    {
        $tc = TransferCertificate::findOrFail($id);
        $tc->delete();

        return redirect()->back()->with('success', 'Transfer Certificate deleted successfully.');
    }



    public function show($id)
    {
        $tc = TransferCertificate::with('student')->findOrFail($id);
        return view('pages.tc.show', compact('tc'));
    }

    public function print($id)
    {
        $tc = TransferCertificate::with('student')->findOrFail($id);
        return view('pages.tc.print', compact('tc'));
    }
    
}
