<?php

namespace App\Http\Controllers\Transport;

use App\Http\Controllers\Controller;
use App\Models\Academic\Group;
use App\Models\Academic\Section;
use App\Models\Academic\Shift;
use App\Models\Academic\StudentClass;
use App\Models\Accounting\FeeType;
use App\Models\Accounting\StudentFee;
use App\Models\Transport\Stoppage;
use App\Models\Transport\StudentTransport;
use App\Models\Transport\TransportRoute;
use App\Services\TransportService;
use Illuminate\Http\Request;

class MultipleAssignTransport extends Controller
{
    //

    public function index(){
        $route_id = '';
        $stoppage_id = '';
        $transport_routes = TransportRoute::pluck('route_name','id');
        return view('pages.transport.assign-student.multiple-assign', compact('transport_routes','route_id', 'stoppage_id'));
    }

    public function multiAssignStoppge(Request $request){
        $student_ids = $request->input('student_id');
        $route_id = $request->input('route_id');
        $stoppage_id = $request->input('stoppage_id');

        $stoppage = Stoppage::where('id', $stoppage_id)->first();
        // $check_exist = StudentTransport::where('student_id', $student_id)->exists();
        $transportFeeTypes = FeeType::where('code', 'Transport')->get();

        // dd($transportFeeTypes,$route_id);
        $message = [];
        $error = [];

        foreach($student_ids as $student_id){
            $check_exist = StudentTransport::where('student_id', $student_id)->exists();

            if(!$check_exist){
                StudentTransport::create([
                    'student_id' => $student_id,
                    'route_id' => $route_id,
                    'stoppage_id' => $stoppage_id,
                    'monthly_cost' => $stoppage->monthly_cost,
                ]);

                foreach ($transportFeeTypes as $transportFeeType) {
                    StudentFee::create([
                        'student_id' => $student_id,
                        'fee_type_id' => $transportFeeType->id,
                        'month' => $transportFeeType->month,
                        'amount' => $stoppage->monthly_cost,
                    ]);
                }
                $message[] = 'Student transport assigned successfully for student ID ' . $student_id . '!';
            }


            if($check_exist){
                StudentTransport::where('student_id', $student_id)->update([
                    'route_id' => $route_id,
                    'stoppage_id' => $stoppage_id,
                    'monthly_cost' => $stoppage->monthly_cost,
                ]);

                foreach ($transportFeeTypes as $transportFeeType) {
                    StudentFee::where('student_id', $student_id)->where('fee_type_id', $transportFeeType->id)->update([
                        'amount' => $stoppage->monthly_cost,
                    ]);
                }

                $message[] = 'Student transport updated successfully for student ID ' . $student_id . '!';
            }

        }

         // Return messages to the view
        return redirect()->back()->with([
            'message' => implode('<br>', $message),
            'error' => implode('<br>', $error)
        ]);

    }


    public function index22(Request $request, TransportService $transportService){
        $this->authorize('transport-management.assign-student.view');
        $students = $transportService->get($request->query());
        $studentClasses = StudentClass::pluck('class_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name', 'id');

        // $transport_routes = TransportRoute::pluck('route_name', 'id');
        $transport_routes = TransportRoute::with('vehicle')
        ->get()
        ->mapWithKeys(function ($route) {
            $vehicleName = $route->vehicle->vehicle_number ?? 'N/A'; // Handle cases where vehicle might be null
            return [$route->id => "$route->route_name ($vehicleName)"];
        });

    }

    public function assignStoppge22(Request $request)
    {
        $student_id = $request->input('student_id');
        $route_id = $request->input('route_id');
        $stoppage_id = $request->input('stoppage_id');

        $stoppage = Stoppage::where('id', $stoppage_id)->first();

        $check_exist = StudentTransport::where('student_id', $student_id)->exists();

        $transportFeeTypes = FeeType::where('code', 'Transport')->get();

        if(!$check_exist){
            StudentTransport::create([
                'student_id' => $student_id,
                'route_id' => $route_id,
                'stoppage_id' => $stoppage_id,
                'monthly_cost' => $stoppage->monthly_cost,
            ]);

            foreach ($transportFeeTypes as $transportFeeType) {
                StudentFee::create([
                    'student_id' => $student_id,
                    'fee_type_id' => $transportFeeType->id,
                    'month' => $transportFeeType->month,
                    'amount' => $stoppage->monthly_cost,
                ]);
            }
            return response()->json([
                'success' => true,
                'message' => 'Student transport assigned successfully!',
            ]);
        }


        if($check_exist){
            StudentTransport::where('student_id', $student_id)->update([
                'route_id' => $route_id,
                'stoppage_id' => $stoppage_id,
                'monthly_cost' => $stoppage->monthly_cost,
            ]);

            foreach ($transportFeeTypes as $transportFeeType) {
                StudentFee::where('student_id', $student_id)->where('fee_type_id', $transportFeeType->id)->update([
                    'amount' => $stoppage->monthly_cost,
                ]);
            }
            return response()->json([
                'success' => true,
                'message' => 'Student transport updated successfully!',
            ]);
        }

    }
}
