<?php

namespace App\Http\Controllers\Transport;

use App\Http\Controllers\Controller;
use App\Models\Transport\Stoppage;
use App\Models\Transport\TransportRoute;
use Illuminate\Http\Request;

class StoppageController extends Controller
{
    public function index()
    {
        $stoppages = Stoppage::all();
        // $transport_routes = TransportRoute::pluck('route_name', 'id');
        return view('pages.transport.stoppage.index', compact('stoppages'));
    }

    public function create()
    {
        return view('pages.transport.stoppage.create');
    }

    public function store(Request $request)
    {

        $request->validate([
            'name' => 'required',
        ]);

        Stoppage::create([
            'branch_id' => auth()->user()->branch_id,
            'name' => $request->name,
        ]);

        return redirect()->route('stoppage.index')->with('success', 'Stoppage created successfully.');
    }

    public function edit(Stoppage $stoppage)
    {
        return view('pages.transport.stoppage.edit', compact('stoppage'));
    }

    public function update(Request $request, Stoppage $stoppage)
    {
        $request->validate([
            'name' => 'required',
        ]);
        $stoppage->update([
            'name' => $request->name,
        ]);

        return redirect()->route('stoppage.index')->with('success', 'Stoppage updated successfully.');
    }

    public function destroy(Stoppage $stoppage)
    {
        $stoppage->delete();

        return redirect()->route('stoppage.index')->with('success', 'Stoppage deleted successfully.');
    }


    public function listByRoute(Request $request)
    {
        $stoppages = Stoppage::where('route_id', $request->route_id)->get();
        return response()->json($stoppages);
    }
}
