<?php

namespace App\Http\Controllers\Transport;

use App\Constants\Status;
use Illuminate\Http\Request;
use App\Models\Academic\Group;
use App\Models\Academic\Shift;
use App\Models\Academic\Section;
use App\Models\Hostel\HostelRoom;
use App\Models\Accounting\FeeType;
use App\Models\Transport\Stoppage;
use App\Services\TransportService;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Academic\StudentClass;
use App\Models\Accounting\StudentFee;
use App\Models\Transport\StudentTransport;

class StudentTransportController extends Controller
{
    public function index(Request $request, TransportService $transportService)
    {
        $this->authorize('transport-management.assign-student.view');
        $students = $transportService->get($request->query());
        $studentClasses = StudentClass::pluck('class_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $sections = Section::pluck('section_name', 'id');
        $stoppages = Stoppage::pluck('name', 'id');
        // dd($students);
        return view('pages.transport.assign-student.index', compact('students', 'studentClasses', 'groups', 'shifts', 'sections', 'stoppages'));
    }

    public function assignStoppge(Request $request)
    {
        $request->validate([
            'student_id'   => 'required|exists:student_infos,id',
            'stoppage_id'  => 'required|exists:stoppages,id',
            'monthly_cost' => 'required|numeric|min:0',
        ]);

        // If monthly cost is 0 → remove transport
        if ((float) $request->monthly_cost == 0) {
            StudentTransport::where('student_id', $request->student_id)->delete();

            return response()->json([
                'success' => true,
                'message' => 'Transport removed successfully'
            ]);
        }

        // Otherwise store or update
        StudentTransport::updateOrCreate(
            ['student_id' => $request->student_id],
            [
                'stoppage_id'  => $request->stoppage_id,
                'monthly_cost' => $request->monthly_cost,
            ]
        );

        return response()->json([
            'success' => true,
            'message' => 'Transport assigned successfully'
        ]);
    }





    // public function assignStoppge(Request $request)
    // {
    //     $student_id = $request->input('student_id');
    //     $route_id = $request->input('route_id');
    //     $stoppage_id = $request->input('stoppage_id');

    //     $stoppage = Stoppage::where('id', $stoppage_id)->first();

    //     $check_exist = StudentTransport::where('student_id', $student_id)->exists();

    //     $transportFeeTypes = FeeType::where('code', 'Transport')->get();

    //     if(!$check_exist){
    //         StudentTransport::create([
    //             'student_id' => $student_id,
    //             'route_id' => $route_id,
    //             'stoppage_id' => $stoppage_id,
    //             'monthly_cost' => $stoppage->monthly_cost,
    //         ]);

    //         foreach ($transportFeeTypes as $transportFeeType) {
    //             StudentFee::create([
    //                 'student_id' => $student_id,
    //                 'fee_type_id' => $transportFeeType->id,
    //                 'month' => $transportFeeType->month,
    //                 'amount' => $stoppage->monthly_cost,
    //             ]);
    //         }
    //         return response()->json([
    //             'success' => true,
    //             'message' => 'Student transport assigned successfully!',
    //         ]);
    //     }


    //     if($check_exist){
    //         StudentTransport::where('student_id', $student_id)->update([
    //             'route_id' => $route_id,
    //             'stoppage_id' => $stoppage_id,
    //             'monthly_cost' => $stoppage->monthly_cost,
    //         ]);

    //         foreach ($transportFeeTypes as $transportFeeType) {
    //             StudentFee::where('student_id', $student_id)->where('fee_type_id', $transportFeeType->id)->update([
    //                 'amount' => $stoppage->monthly_cost,
    //             ]);
    //         }
    //         return response()->json([
    //             'success' => true,
    //             'message' => 'Student transport updated successfully!',
    //         ]);
    //     }

    // }

    public function searchStopages(Request $request)
    {

        $hostel_rooms = HostelRoom::with(['hostel', 'roomType'])
            ->leftJoin('student_hostels', function ($join) {
                $join->on('hostel_rooms.id', '=', 'student_hostels.hostel_room_id')
                    ->where('student_hostels.status', '=', Status::ASSIGNED);
            })
            ->select('hostel_rooms.*', DB::raw('COUNT(student_hostels.id) as assigned_beds'))
            ->where('hostel_rooms.room_name', $request->room_no)
            ->groupBy('hostel_rooms.id')
            ->get()
            ->map(function ($room) {
                // Ensure assigned_beds is not null
                $room->assigned_beds = $room->assigned_beds ?? 0;
                // Calculate empty beds correctly
                $room->empty_beds = $room->no_of_bed - $room->assigned_beds;
                return $room;
            });
        return response()->json($hostel_rooms);
    }

    public function studentAssignedStopage(Request $request)
    {

        $hostel_rooms = HostelRoom::with(['hostel', 'roomType'])
            ->leftJoin('student_hostels', function ($join) {
                $join->on('hostel_rooms.id', '=', 'student_hostels.hostel_room_id')
                    ->where('student_hostels.status', '=', Status::ASSIGNED);
            })
            ->select('hostel_rooms.*', DB::raw('COUNT(student_hostels.id) as assigned_beds'))
            ->where('hostel_rooms.id', $request->hostel_room_id)
            ->groupBy('hostel_rooms.id')
            ->first();

        return response()->json($hostel_rooms);
    }
}
