<?php

namespace App\Http\Controllers\Transport;

use App\Http\Controllers\Controller;
use App\Models\Transport\Vehicle;
use App\Models\Transport\TransportRoute;
use Illuminate\Http\Request;

class TransportRouteController extends Controller
{
    public function index()
    {
        $routes = TransportRoute::with('vehicle')->get();
        return view('pages.transport.route.index', compact('routes'));
    }

    public function create()
    {
        $vehicles = Vehicle::pluck('vehicle_number', 'id');
        return view('pages.transport.route.create', compact('vehicles'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'route_name' => 'required',
            'start_point' => 'required',
            'end_point' => 'required',
            'vehicle_id' => 'required',
            // 'driver_id' => 'required|integer',
            'departure_time' => 'required',
            'arrival_time' => 'required',
        ]);
        $branchId = auth()->user()->branch_id;
        TransportRoute::create(array_merge($request->all(), ['branch_id' => $branchId]));
        return redirect()->route('transport-route.index')->with('success', 'Transport Route created successfully.');
    }

    public function edit($id)
    {
        $transport_route = TransportRoute::find($id);
        $vehicles = Vehicle::pluck('vehicle_number', 'id');
        return view('pages.transport.route.edit', compact('transport_route', 'vehicles'));
    }

    public function update(Request $request, $id)
    {
        $transport_route = TransportRoute::find($id);
        $request->validate([
            'route_name' => 'required',
            'start_point' => 'required',
            'end_point' => 'required',
            'vehicle_id' => 'required',
            'driver_id' => 'required|integer',
            'departure_time' => 'required',
            'arrival_time' => 'required',
        ]);

        $transport_route->update($request->all());
        return redirect()->route('transport-route.index')->with('success', 'Transport Route updated successfully.');
    }

    public function destroy($id)
    {
        $transport_route = TransportRoute::find($id);
        $transport_route->delete();
        return redirect()->route('transport-route.index')->with('success', 'Transport Route deleted successfully.');
    }
}
