<?php

namespace App\Http\Controllers\Transport;

use App\Constants\Common;
use App\Http\Controllers\Controller;
use App\Models\Transport\Vehicle;
use Illuminate\Http\Request;

class VehicleController extends Controller
{
    public function index()
    {
        $vehicles = Vehicle::all();
        $vehicle_type = Common::VEHICLE_TYPE;
        return view('pages.transport.vehicles.index', compact('vehicles', 'vehicle_type'));
    }

    public function create()
    {
        return view('vehicle.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'vehicle_number' => 'required',
            'vehicle_type' => 'required',
            'capacity' => 'required',
        ]);

        $branchId = auth()->user()->branch_id;
        Vehicle::create(array_merge($request->all(), ['branch_id' => $branchId]));
        
        return redirect()->route('vehicle.index')->with('success', 'Vehicle created successfully!');
    }

    public function show(Vehicle $vehicle)
    {
        return view('vehicle.show', compact('vehicle'));
    }

    public function edit(Vehicle $vehicle)
    {
        return view('vehicle.edit', compact('vehicle'));
    }

    public function update(Request $request, Vehicle $vehicle)
    {
        $request->validate([
            'vehicle_number' => 'required',
            'vehicle_type' => 'required',
            'capacity' => 'required',
        ]);

        $vehicle->update($request->all());
        return redirect()->route('vehicle.index')->with('success', 'Vehicle updated successfully!');
    }

    public function destroy(Vehicle $vehicle)
    {
        $vehicle->delete();
        return redirect()->route('vehicle.index')->with('success', 'Vehicle deleted successfully!');
    }
}
