<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AttendanceReport extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'date' => 'required',
            'attendance_type' => 'required',
            'student_class_id' => 'required',
            'shift_id' => 'required',
        ];
    }

     /**
     * Custom error messages.
     */
    public function messages(): array
    {
        return [
            'date.required' => 'The date field  is required.',
            'attendance_type.required' => 'The type field  is required.',
            'student_class_id.required' => 'The class field  is required.',
            'shift_id.required' => 'The shift field  is required.',
        ];
    }
}