<?php

namespace App\Http\Requests;

use App\Constants\Accounting;
use Illuminate\Foundation\Http\FormRequest;

class FeeCollectionRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return[
            'student_id' => 'required|exists:student_infos,id',
            'fee_type_id' => 'required|array',
            'fee_type_id.*' => 'required|exists:fee_types,id',
            'amount' => 'required|array',
            'amount.*' => 'required',
            'payment_method' => 'required|in:' . implode(',', array_keys(Accounting::PAYMENT_METHOD)),
        ];
    }

    public function messages()
    {
        return [
            'student_id.required' => 'The student ID is required.',
            'student_id.exists' => 'The selected student ID is invalid.',
            'fee_type_id.required' => 'At least one fee type must be selected.',
            'fee_type_id.array' => 'Fee type ID must be an array.',
            'fee_type_id.*.required' => 'Each selected fee type is required.',
            'fee_type_id.*.exists' => 'The selected fee type is invalid.',
            'amount.required' => 'The amount field is required.',
            'amount.array' => 'Amount must be an array.',
            'amount.*.required' => 'Each amount for fee types is required.',
            'amount.*.numeric' => 'Amount must be a number.',
            'amount.*.min' => 'Amount must be at least 0.',
            'payment_method.required' => 'The payment method is required.',
            'payment_method.in' => 'The selected payment method is invalid.',
        ];
    }
}
