<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StudentInfoRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'nullable|email',
            'mobile_no' => 'required|string|max:20',
            'branch_id' => 'required|integer|exists:branches,id',
            'profile_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            // 'guardian_name' => 'required|string|max:255',
            // 'guardian_occupation' => 'required|string|max:255',
            // 'guardian_mobile' => 'required|string|max:20',
            // 'guardian_email' => 'nullable|email',
            // 'guardian_relationship' => 'required|string|max:255',
            // 'guardian_address' => 'required|string|max:255',
        ];
    }
}
