<?php

namespace App\Models\Academic;

use App\Models\Scopes\BranchFilterScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassRoutine extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function shift()
    {
        return $this->belongsTo(Shift::class, 'shift_id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class, 'student_class_id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id');
    }

    public function routineDetails()
    {
        return $this->hasMany(RoutineDetail::class, 'class_routine_id');
    }

    protected static function booted()
    {
        static::addGlobalScope(new BranchFilterScope);
    }

}
